/*
 * MOAClustererTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.transformer;

import moa.options.ClassOption;
import weka.filters.unsupervised.attribute.Remove;
import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.standalone.GlobalActors;
import adams.flow.sink.DumpFile;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.MOAClusterer;
import adams.flow.transformer.WekaFilter;
import adams.test.TmpFile;

/**
 * Tests the MOAClusterer actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2909 $
 */
public class MOAClustererTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public MOAClustererTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method.
   *
   * @throws Exception if an error occurs reading the example instances.
   */
  protected void setUp() throws Exception {
    super.setUp();

    m_TestHelper.copyResourceToTmp("iris.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile.txt");
  }

  /**
   * Called by JUnit after each test method.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("iris.arff");
    m_TestHelper.deleteFileFromTmp("dumpfile.txt");

    super.tearDown();
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    SingleFileSupplier sfs = new SingleFileSupplier();
    sfs.setFile(new TmpFile("iris.arff"));

    WekaFileReader fr = new WekaFileReader();
    fr.setIncremental(true);

    Remove remove = new Remove();
    remove.setAttributeIndices("last");
    WekaFilter wf = new WekaFilter();
    wf.setFilter(remove);

    ClassOption option = new ClassOption(
	"clusterer",
	'c',
	"The MOA clusterer to use from within ADAMS.",
	moa.clusterers.Clusterer.class,
	"CobWeb",
	"moa.clusterers.CobWeb");

    MOAClusterer cls = new MOAClusterer();
    cls.setClusterer(option);
    cls.setOutputInterval(150);  // 150 is the number of instances in the dataset

    DumpFile df = new DumpFile();
    df.setOutputFile(new TmpFile("dumpfile.txt"));

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{sfs, fr, wf, cls, df});

    return flow;
  }

  /**
   * Performs a regression test, comparing against previously generated output.
   */
  public void testRegression() {
    performRegressionTest(
	new TmpFile("dumpfile.txt"));
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(MOAClustererTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
