/*
 * FTPListerTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.source;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.core.base.BasePassword;
import adams.env.Environment;
import adams.flow.AbstractOnlineFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.source.FTPLister;
import adams.flow.standalone.FTPConnection;

/**
 * Test case for the FTPLister actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3740 $
 */
public class FTPListerTest
  extends AbstractOnlineFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public FTPListerTest(String name) {
    super(name);
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    FTPConnection fc = new FTPConnection();
    fc.setHost("ftp.suse.com");
    fc.setUser("anonymous");
    fc.setPassword(new BasePassword(""));
    fc.setUsePassiveMode(true);

    FTPLister fl = new FTPLister();
    fl.setRemoteDir("/pub");
    fl.setListFiles(true);

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{
	fc,
	fl
    });

    return flow;
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(FTPListerTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
