/**
 * InetUtils.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.net;

import java.net.InetAddress;

/**
 * Utility class for internet-related stuff.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3594 $
 */
public class InetUtils {

  /**
   * Checks whether a connection is available to the specified host.
   *
   * @param host	the host to ping
   * @param timeout	the timeout in milli-seconds
   * @return		true if successfully pinged
   */
  public static boolean hasConnection(String host, int timeout) {
    boolean	result;
    InetAddress	address;

    try {
      address = InetAddress.getByName(host);
      result  = address.isReachable(timeout);
    }
    catch (Exception e) {
      e.printStackTrace();
      result = false;
    }

    return result;
  }
}
