/**
 * URLToStringTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.data.conversion;

import adams.data.conversion.URLToString;
import adams.test.TmpFile;

import java.net.URL;

/**
 * Tests the URLToString conversion.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3758 $
 */
public class URLToStringTest
  extends AbstractConversionTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public URLToStringTest(String name) {
    super(name);
  }

  /**
   * Returns the input data to use in the regression test.
   *
   * @return		the objects
   */
  protected Object[] getRegressionInput() {
    try {
      return new URL[]{
	  new URL("http://www.waikato.ac.nz/"),
	  new URL("https://www.gmail.com/"),
	  new URL("ftp://ftp.suse.com/")
      };
    }
    catch (Exception e) {
      return new URL[0];
    }
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractConversion[] getRegressionSetups() {
    URLToString[]	result;

    result    = new URLToString[1];
    result[0] = new URLToString();

    return result;
  }

  /**
   * Returns the ignored line indices to use in the regression test.
   *
   * @return		the setups
   */
  protected int[] getRegressionIgnoredLineIndices() {
    return new int[0];
  }
}
