/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * EmailSetupDialog.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

import adams.gui.core.BaseDialog;

/**
 * A standalone dialog for email setup.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class EmailSetupDialog
  extends BaseDialog {

  /** for serialization. */
  private static final long serialVersionUID = 3653191762492506746L;

  /** the dialog itself. */
  protected EmailSetupDialog m_Self;

  /** database connection panel. */
  protected EmailSetupPanel m_Panel;

  /** the OK button. */
  protected JButton m_ButtonOK;

  /** the Cancel button. */
  protected JButton m_ButtonCancel;

  /**
   * Creates a modal dialog.
   *
   * @param owner	the owning dialog
   */
  public EmailSetupDialog(Dialog owner) {
    this(owner, "Email setup");
  }

  /**
   * Creates a modal dialog.
   *
   * @param owner	the owning dialog
   * @param title	the title of the dialog
   */
  public EmailSetupDialog(Dialog owner, String title) {
    super(owner, title, ModalityType.DOCUMENT_MODAL);
  }

  /**
   * Creates a modal dialog.
   *
   * @param owner	the owning frame
   */
  public EmailSetupDialog(Frame owner) {
    this(owner, "Email setup");
  }

  /**
   * Creates a modal dialog.
   *
   * @param owner	the owning frame
   * @param title	the title of the dialog
   */
  public EmailSetupDialog(Frame owner, String title) {
    super(owner, title, true);
  }

  /**
   * For initializing members.
   */
  protected void initialize() {
    super.initialize();

    m_Self = this;
  }

  /**
   * initializes the GUI elements.
   */
  protected void initGUI() {
    JPanel	panel;

    super.initGUI();

    setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
    setLayout(new BorderLayout());

    // DB connection
    m_Panel = new EmailSetupPanel();
    add(m_Panel, BorderLayout.CENTER);

    // buttons
    panel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
    add(panel, BorderLayout.SOUTH);

    m_ButtonOK = new JButton("OK");
    m_ButtonOK.setMnemonic('O');
    m_ButtonOK.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	m_Panel.activate();
        m_Self.setVisible(false);
      }
    });
    panel.add(m_ButtonOK);

    m_ButtonCancel = new JButton("Cancel");
    m_ButtonCancel.setMnemonic('C');
    m_ButtonCancel.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        m_Self.setVisible(false);
      }
    });
    panel.add(m_ButtonCancel);

    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
	beforeHide();
        super.windowClosing(e);
      }
    });

    pack();

    // adjust size
    setSize(400, getHeight());
  }
}
