/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.FTPConnection;
import adams.flow.transformer.AbstractTransformer;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;

public class FTPSend
extends AbstractTransformer {
    private static final long serialVersionUID = -5015637337437403790L;
    protected String m_RemoteDir;
    protected FTPConnection m_Connection;

    public String globalInfo() {
        return "Uploads a file to a remote directory.\nThe file name of a successful upload gets forwarded.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"/pub");
    }

    public String getQuickInfo() {
        String result = "upload to  ";
        String variable = this.getOptionManager().getVariableForProperty("remoteDir");
        result = variable != null ? result + variable : result + this.m_RemoteDir;
        return result;
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The FTP directory to upload the file to.";
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (FTPConnection)ActorUtils.findClosestType((AbstractActor)this, FTPConnection.class);
            if (this.m_Connection == null) {
                result = "No " + FTPConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        String filename = (String)this.m_InputToken.getPayload();
        PlaceholderFile file = new PlaceholderFile(filename);
        String remotefile = this.m_RemoteDir + "/" + file.getName();
        FTPClient client = this.m_Connection.getFTPClient();
        BufferedInputStream stream = null;
        try {
            if (this.isDebugOn()) {
                this.debug("Uploading " + file + " to " + remotefile);
            }
            stream = new BufferedInputStream(new FileInputStream(file.getAbsoluteFile()));
            client.storeFile(remotefile, (InputStream)stream);
            stream.close();
            this.m_OutputToken = new Token((Object)filename);
        }
        catch (Exception e) {
            String msg = "Failed to upload file '" + file + "' to '" + remotefile + "': ";
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace((Throwable)e);
            result = msg + e;
            this.m_OutputToken = null;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }
}

