/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.core.io.PlaceholderFile;
import adams.core.net.EmailAddress;
import adams.gui.core.BaseDialog;
import adams.gui.dialog.ComposeEmailPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ComposeEmailDialog
extends BaseDialog {
    private static final long serialVersionUID = 3653191762492506746L;
    protected ComposeEmailPanel m_Panel;
    protected boolean m_CloseOnSend;
    protected boolean m_DialogClosedByUser;

    public ComposeEmailDialog(Dialog owner) {
        this(owner, "Compose email");
    }

    public ComposeEmailDialog(Dialog owner, String title) {
        super(owner, title, Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public ComposeEmailDialog(Frame owner) {
        this(owner, "Compose email");
    }

    public ComposeEmailDialog(Frame owner, String title) {
        super(owner, title, true);
    }

    protected void initGUI() {
        super.initGUI();
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.m_Panel = new ComposeEmailPanel();
        this.m_Panel.addSendListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComposeEmailDialog.this.closeOnSuccessfulSend();
            }
        });
        this.add((Component)((Object)this.m_Panel), "Center");
        this.pack();
        this.setSize(600, 500);
    }

    public void clear() {
        this.m_Panel.clear();
    }

    protected void closeOnSuccessfulSend() {
        if (this.getCloseOnSend() && this.getLastSendResult() == null) {
            this.m_DialogClosedByUser = false;
            this.setVisible(false);
        }
    }

    public String send() {
        String result = this.m_Panel.send();
        this.closeOnSuccessfulSend();
        return result;
    }

    public void setFrom(EmailAddress value) {
        this.m_Panel.setFrom(value);
    }

    public EmailAddress getFrom() {
        return this.m_Panel.getFrom();
    }

    public void setTO(EmailAddress[] value) {
        this.m_Panel.setTO(value);
    }

    public EmailAddress[] getTO() {
        return this.m_Panel.getTO();
    }

    public void setCC(EmailAddress[] value) {
        this.m_Panel.setCC(value);
    }

    public EmailAddress[] getCC() {
        return this.m_Panel.getCC();
    }

    public void setBCC(EmailAddress[] value) {
        this.m_Panel.setBCC(value);
    }

    public EmailAddress[] getBCC() {
        return this.m_Panel.getBCC();
    }

    public void setAttachments(PlaceholderFile[] value) {
        this.m_Panel.setAttachments(value);
    }

    public PlaceholderFile[] getAttachments() {
        return this.m_Panel.getAttachments();
    }

    public void setSubject(String value) {
        this.m_Panel.setSubject(value);
    }

    public String getSubject() {
        return this.m_Panel.getSubject();
    }

    public void setBody(String value) {
        this.m_Panel.setBody(value);
    }

    public String getBody() {
        return this.m_Panel.getBody();
    }

    public void setSignature(String value) {
        this.m_Panel.setSignature(value);
    }

    public String getSignature() {
        return this.m_Panel.getSignature();
    }

    public String getLastSendResult() {
        return this.m_Panel.getLastSendResult();
    }

    public void setCloseOnSend(boolean value) {
        this.m_CloseOnSend = value;
    }

    public boolean getCloseOnSend() {
        return this.m_CloseOnSend;
    }

    public boolean getDialogClosedByUser() {
        return this.m_DialogClosedByUser;
    }

    protected void beforeShow() {
        super.beforeShow();
        this.m_Panel.grabFocus();
        this.m_DialogClosedByUser = true;
    }
}

