/**
 * EmailRecipient.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.sendto;

import java.awt.Frame;
import java.awt.Dialog.ModalityType;
import java.io.File;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.gui.dialog.ComposeEmailDialog;

/**
 * Action for sending files as emails.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4095 $
 */
public class EmailRecipient
  extends AbstractSendToAction {

  /** for serialization. */
  private static final long serialVersionUID = 5177606045614245912L;

  /**
   * Returns the short description of the sendto action.
   * Description gets used for menu items.
   *
   * @return		the short description
   */
  public String getAction() {
    return "Email recipient";
  }

  /**
   * Returns the file name of the icon.
   *
   * @return		the filename or null if no icon available
   */
  public String getIconName() {
    return "email.png";
  }

  /**
   * Returns the classes that the action accepts.
   *
   * @return		the accepted classes
   */
  public Class[] accepts() {
    return new Class[]{
	File.class,
	File[].class,
	PlaceholderFile.class,
	PlaceholderFile[].class,
	String.class
    };
  }

  /**
   * Performs the actual sending/forwarding/processing of the data.
   *
   * @param o		the object to send
   * @return		null if everything OK, otherwise error message
   */
  public String send(Object o) {
    String		result;
    ComposeEmailDialog	dialog;
    PlaceholderFile[]	files;
    File[]		tmpFiles;
    int			i;
    String		body;
    StringBuilder	subject;

    dialog = new ComposeEmailDialog((Frame) Environment.getInstance().getApplicationFrame());
    dialog.setModalityType(ModalityType.DOCUMENT_MODAL);
    dialog.setCloseOnSend(true);

    files = new PlaceholderFile[0];
    body  = "";
    if (o instanceof File) {
      files = new PlaceholderFile[]{new PlaceholderFile((File) o)};
    }
    else if (o instanceof File[]) {
      tmpFiles = (File[]) o;
      files    = new PlaceholderFile[tmpFiles.length];
      for (i = 0; i < tmpFiles.length; i++)
	files[i] = new PlaceholderFile(tmpFiles[i]);
    }
    else if (o instanceof PlaceholderFile) {
      files = new PlaceholderFile[]{(PlaceholderFile) o};
    }
    else if (o instanceof PlaceholderFile[]) {
      files = (PlaceholderFile[]) o;
    }
    else if (o instanceof String) {
      body = (String) o;
    }
    else {
      throw new IllegalArgumentException("Unhandled class type: " + o.getClass());
    }

    subject = new StringBuilder();
    for (i = 0; i < files.length; i++) {
      if (i > 0)
	subject.append(", ");
      subject.append(files[i].getName());
    }

    dialog.setAttachments(files);
    dialog.setSubject(subject.toString());
    dialog.setBody(body);
    dialog.setLocationRelativeTo(null);
    dialog.setVisible(true);

    result = dialog.getLastSendResult();
    if ((result == null) && dialog.getDialogClosedByUser())
      result = "Email sending canceled by user!";

    return result;
  }
}
