/*
 * BrowserTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.sink;

import adams.env.Environment;
import adams.core.net.InetUtils;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionUtils;
import junit.framework.Test;
import junit.framework.TestSuite;
import adams.flow.core.AbstractActor;
import adams.flow.control.Flow;
import adams.flow.AbstractOnlineFlowTest;

/**
 * Test for Browser actor.
 *
 * @author fracpete
 * @author adams.core.option.FlowJUnitTestProducer (code generator)
 * @version $Revision: 3740 $
 */
public class BrowserTest
  extends AbstractOnlineFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public BrowserTest(String name) {
    super(name);
  }

  /**
   *
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(BrowserTest.class);
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    AbstractArgumentOption	argOption;
    String			host;

    Flow flow = new Flow();

    host = "www.waikato.ac.nz";
    if (!InetUtils.hasConnection(host, 3000))
      System.err.println("No connection to host '" + host + "'? Trying anyway...");
    try {
      argOption = (AbstractArgumentOption) flow.getOptionManager().findByProperty("actors");
      adams.flow.core.AbstractActor[] tmp1 = new adams.flow.core.AbstractActor[2];
      adams.flow.source.SingleURLSupplier tmp2 = new adams.flow.source.SingleURLSupplier();
      argOption = (AbstractArgumentOption) tmp2.getOptionManager().findByProperty("URL");
      adams.core.base.BaseURL tmp3 = new adams.core.base.BaseURL("http://" + host + "/");
      tmp2.setURL(tmp3);

      tmp1[0] = tmp2;
      adams.flow.sink.Browser tmp4 = new adams.flow.sink.Browser();
      tmp1[1] = tmp4;
      flow.setActors(tmp1);

    }
    catch (Exception e) {
      fail("Failed to set up actor: " + e);
    }

    return flow;
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(adams.env.Environment.class);
    runTest(suite());
  }
}

