/*
 * EmailAddress.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.core.net;

import javax.mail.internet.InternetAddress;

import adams.core.base.BaseString;

/**
 * Wrapper for a regular expression string to be editable in the GOE. Basically
 * the same as BaseString, but checks whether the string represents a valid
 * address using <code>javax.mail.internet.InternetAddress</code>.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3636 $
 */
public class EmailAddress
  extends BaseString {

  /** for serialization. */
  private static final long serialVersionUID = -8687858764646783666L;

  /**
   * Initializes the email address with a dummy one.
   */
  public EmailAddress() {
    this("john.doe@nowhere.org");
  }

  /**
   * Initializes the object with the string to parse.
   *
   * @param s		the string to parse
   */
  public EmailAddress(String s) {
    super(s);
  }

  /**
   * Checks whether the string value is a valid presentation for this class.
   *
   * @param value	the string value to check
   * @return		true if valid email address
   * @see		InternetAddress
   */
  public boolean isValid(String value) {
    try {
      new InternetAddress(value);
      return true;
    }
    catch (Exception e) {
      return false;
    }
  }

  /**
   * Returns a tool tip for the GUI editor (ignored if null is returned).
   *
   * @return		the tool tip
   */
  public String getTipText() {
    return "Email address.";
  }
}
