/**
 * VariableFileExtensionPdfProclet.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.core.io;

import adams.core.base.BaseString;

/**
 * Interface for PDF proclets that allow the user to modify the file extensions
 * to work on.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2028 $
 */
public interface VariableFileExtensionPdfProclet {

  /**
   * Sets the extensions that the processor can process.
   *
   * @param value	the extensions (no dot)
   */
  public void setExtensions(BaseString[] value);

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String extensionsTipText();
}
