/*
 * PDFCreateTest.java
 * Copyright (C) 2010-2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.transformer;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.control.Trigger;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.SingleFileSupplier;
import adams.test.TmpDirectory;
import adams.test.TmpFile;

/**
 * Tests the PDFCreate actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3576 $
 */
public class PDFCreateTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public PDFCreateTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method. Copies some resource files into
   * the tmp directory
   *
   * @throws Exception if an error occurs reading the example instances.
   */
  protected void setUp() throws Exception {
    super.setUp();

    m_TestHelper.copyResourceToTmp("bolts_small.csv");
    m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    m_TestHelper.deleteFileFromTmp("dumpfile.pdf");
  }

  /**
   * Called by JUnit after each test method. Removes some tmp files again.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("bolts_small.csv");
    m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    m_TestHelper.deleteFileFromTmp("dumpfile.pdf");

    super.tearDown();
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    SingleFileSupplier sfs = new SingleFileSupplier();
    sfs.setFile(new TmpFile("bolts_small.csv"));

    PDFCreate pdf = new PDFCreate();
    pdf.setOutput(new TmpFile("dumpfile.pdf"));

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{sfs, pdf});

    return flow;
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(PDFCreateTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
