/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.print;

import adams.gui.print.BufferedImageBasedWriter;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class PDFWriter
extends BufferedImageBasedWriter {
    private static final long serialVersionUID = -3177842835940277934L;
    protected int m_ImageRotation;
    protected double m_ImageScale;

    public String globalInfo() {
        return "Outputs PDF documents.";
    }

    public String getDescription() {
        return "PDF document";
    }

    public String[] getExtensions() {
        return new String[]{".pdf"};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("rotation", "imageRotation", (Object)0);
        this.m_OptionManager.add("scale", "imageScale", (Object)0.9);
    }

    public void setImageRotation(int value) {
        if (value >= 0 && value <= 360) {
            this.m_ImageRotation = value;
            this.reset();
        } else {
            this.getSystemErr().println("Degrees must be from 0 to 360!");
        }
    }

    public int getImageRotation() {
        return this.m_ImageRotation;
    }

    public String imageRotationTipText() {
        return "The degrees to rotate the images by (0-360).";
    }

    public void setImageScale(double value) {
        if (value > 0.0 && value <= 1.0) {
            this.m_ImageScale = value;
            this.reset();
        } else {
            this.getSystemErr().println("Scale must satisfy 0<x<1!");
        }
    }

    public double getImageScale() {
        return this.m_ImageScale;
    }

    public String imageScaleTipText() {
        return "The scale factor (0-1) for images based on the page size.";
    }

    public void generateOutput() throws Exception {
        BufferedImage bi = this.createBufferedImage();
        float scale = (float)this.m_ImageScale;
        Document doc = new Document();
        PdfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(this.getFile().getAbsoluteFile()));
        doc.open();
        com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance((Image)Toolkit.getDefaultToolkit().createImage(bi.getSource()), null);
        if (this.m_ImageRotation != 0) {
            image.setRotationDegrees((float)this.m_ImageRotation);
            image.rotate();
        }
        image.scaleToFit(doc.getPageSize().getWidth() * scale, doc.getPageSize().getHeight() * scale);
        doc.add((Element)image);
        doc.close();
    }
}

