/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.Range;
import adams.core.io.PlaceholderFile;
import de.intarsys.pdf.content.CSDeviceBasedInterpreter;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.text.CSTextExtractor;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectWalkerDeep;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.pdf.platform.cwt.image.awt.ImageConverterPdf2Awt;
import de.intarsys.pdf.tools.kernel.PDFGeometryTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.Vector;

public class JPod {
    public static PDDocument load(String file) {
        return JPod.load((File)new PlaceholderFile(file));
    }

    public static PDDocument load(File file) {
        PDDocument result;
        FileLocator locator = new FileLocator(file.getAbsolutePath());
        try {
            result = PDDocument.createFromLocator((ILocator)locator);
        }
        catch (Exception e) {
            System.err.println("Failed to open PDF file '" + file + "':");
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static void close(PDDocument document) {
        if (document != null) {
            try {
                document.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean save(PDDocument doc, String file) {
        return JPod.save(doc, (File)new PlaceholderFile(file));
    }

    public static boolean save(PDDocument doc, File file) {
        boolean result;
        try {
            FileLocator locator = new FileLocator(file.getAbsolutePath());
            doc.save((ILocator)locator, null);
            result = true;
        }
        catch (Exception e) {
            System.err.println("Failed to save PDF document to file '" + file + "':");
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public static String extract(File file) {
        return JPod.extract(file, new Range("first-last"));
    }

    public static String extract(File file, Range range) {
        StringBuilder result = new StringBuilder();
        PDDocument document = JPod.load(file);
        if (document != null) {
            try {
                PDPageTree tree = document.getPageTree();
                range.setMax(tree.getCount());
                int[] pages = range.getIntIndices();
                for (int i = 0; i < pages.length; ++i) {
                    CSTextExtractor extractor = new CSTextExtractor();
                    PDPage page = tree.getPageAt(pages[i]);
                    AffineTransform pageTx = new AffineTransform();
                    PDFGeometryTools.adjustTransform((AffineTransform)pageTx, (PDPage)page);
                    extractor.setDeviceTransform(pageTx);
                    CSDeviceBasedInterpreter interpreter = new CSDeviceBasedInterpreter(null, (ICSDevice)extractor);
                    interpreter.process(page.getContentStream(), page.getResources());
                    result.append(extractor.getContent());
                    result.append("\n");
                }
            }
            catch (Exception e) {
                result = null;
                System.err.println("Failed to extract text from '" + file + "': ");
                e.printStackTrace();
            }
            JPod.close(document);
        }
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public static List<BufferedImage> extractImages(File file) {
        final Vector<BufferedImage> result = new Vector<BufferedImage>();
        boolean failed = false;
        PDDocument document = JPod.load(file);
        if (document != null) {
            try {
                COSObjectWalkerDeep walker = new COSObjectWalkerDeep(){

                    public Object visitFromStream(COSStream stream) throws COSVisitorException {
                        if (!PDImage.CN_Subtype_Image.equals((Object)stream.getDict().get(PDObject.DK_Subtype))) {
                            return null;
                        }
                        PDImage image = (PDImage)PDImage.META.createFromCos((COSObject)stream);
                        if (image == null) {
                            return null;
                        }
                        try {
                            ImageConverterPdf2Awt converter = new ImageConverterPdf2Awt(image);
                            BufferedImage bi = converter.getBufferedImage();
                            result.add(bi);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                };
                document.cosGetDoc().getCatalog().cosGetObject().accept((ICOSObjectVisitor)walker);
            }
            catch (Exception e) {
                System.err.println("Failed to extract text from '" + file + "': ");
                e.printStackTrace();
                failed = true;
            }
            JPod.close(document);
        }
        if (failed) {
            return null;
        }
        return result;
    }

    public static int getPageCount(File file) {
        int result = -1;
        PDDocument document = JPod.load(file);
        if (document != null) {
            result = document.getPageTree().getCount();
        }
        JPod.close(document);
        return result;
    }
}

