/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.core.io.JPod;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class PDFExtractText
extends AbstractTransformer {
    private static final long serialVersionUID = -5712406930007899590L;
    protected PlaceholderFile m_Output;
    protected Range m_Pages;

    public String globalInfo() {
        return "Actor for extracting the text of a range of pages from a PDF file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pages", "pages", (Object)"first-last");
    }

    protected void initialize() {
        super.initialize();
        this.m_Pages = new Range();
    }

    public void setPages(String value) {
        this.m_Pages.setRange(value);
        this.reset();
    }

    public String getPages() {
        return this.m_Pages.getRange();
    }

    public String pagesTipText() {
        return "The range of pages to extract; " + this.m_Pages.getExample();
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("pages");
        String result = variable != null ? variable : this.m_Pages.getRange();
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String content;
        String result = null;
        File file = this.m_InputToken.getPayload() instanceof File ? (File)this.m_InputToken.getPayload() : new PlaceholderFile((String)this.m_InputToken.getPayload());
        if (this.isDebugOn()) {
            this.debug("Extracting text from '" + file + "'");
        }
        if ((content = JPod.extract(file, this.m_Pages)) == null) {
            result = "Failed to extract text from '" + file + "'!";
        } else {
            this.m_OutputToken = new Token((Object)content);
        }
        return result;
    }
}

