/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.base.BaseString;
import adams.core.base.BaseText;
import adams.core.io.AbstractPdfProclet;
import adams.core.io.PdfFont;
import adams.core.io.VariableFileExtensionPdfProclet;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import java.awt.Color;
import java.io.File;

public class HeadlinePdfProclet
extends AbstractPdfProclet
implements VariableFileExtensionPdfProclet {
    private static final long serialVersionUID = 3962046484864891107L;
    protected BaseText m_Headline;
    protected PdfFont m_FontHeadline;
    protected Color m_ColorHeadline;
    protected BaseString[] m_Extensions;
    protected boolean m_FirstPageOnly;

    public String globalInfo() {
        return "Adds a simple headline, but no file content.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("headline", "headline", (Object)new BaseText("Fill in headline"));
        this.m_OptionManager.add("font-headline", "fontHeadline", (Object)new PdfFont("Helvetica", "Bold", 14.0f));
        this.m_OptionManager.add("color-headline", "colorHeadline", (Object)Color.BLACK);
        this.m_OptionManager.add("extension", "extensions", (Object)new BaseString[]{new BaseString("*")});
        this.m_OptionManager.add("first-page-only", "firstPageOnly", (Object)false);
    }

    public void setHeadline(BaseText value) {
        this.m_Headline = value;
        this.reset();
    }

    public BaseText getHeadline() {
        return this.m_Headline;
    }

    public String headlineTipText() {
        return "The headline to add, can be multi-line.";
    }

    public void setFontHeadline(PdfFont value) {
        this.m_FontHeadline = value;
        this.reset();
    }

    public PdfFont getFontHeadline() {
        return this.m_FontHeadline;
    }

    public String fontHeadlineTipText() {
        return "The font to use for the headline.";
    }

    public void setColorHeadline(Color value) {
        this.m_ColorHeadline = value;
        this.reset();
    }

    public Color getColorHeadline() {
        return this.m_ColorHeadline;
    }

    public String colorHeadlineTipText() {
        return "The color to use for the headline.";
    }

    public BaseString[] getExtensions() {
        return this.m_Extensions;
    }

    public void setExtensions(BaseString[] value) {
        this.m_Extensions = value;
        this.reset();
    }

    public String extensionsTipText() {
        return "The file extension(s) that the processor will be used for.";
    }

    public void setFirstPageOnly(boolean value) {
        this.m_FirstPageOnly = value;
        this.reset();
    }

    public boolean getFirstPageOnly() {
        return this.m_FirstPageOnly;
    }

    public String firstPageOnlyTipText() {
        return "If set to true, then the headline is only added to the first page.";
    }

    public boolean canProcess(AbstractPdfProclet.DocumentState state, File file) {
        if (this.m_FirstPageOnly) {
            if (state.numTotalFiles() == 0) {
                return super.canProcess(state, file);
            }
            return false;
        }
        return super.canProcess(state, file);
    }

    protected boolean doProcess(Document doc, AbstractPdfProclet.DocumentState state, File file) throws Exception {
        boolean result = this.addFilename(doc, state, file);
        if (!result) {
            return result;
        }
        String[] paragraphs = this.m_Headline.getValue().split("\n");
        for (int i = 0; i < paragraphs.length && (result = doc.add((Element)new Paragraph(paragraphs[i], this.m_FontHeadline.toFont(this.m_ColorHeadline)))); ++i) {
            state.contentAdded();
        }
        return result;
    }
}

