/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.CloneHandler;
import adams.core.Utils;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import java.awt.Color;
import java.io.Serializable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfFont
implements Serializable,
CloneHandler<PdfFont> {
    private static final long serialVersionUID = -8327183921477550848L;
    public static final char SEPARATOR = '-';
    public static final String NORMAL = "Normal";
    public static final String BOLD = "Bold";
    public static final String ITALIC = "Italic";
    public static final String STRIKETHRU = "StrikeThru";
    public static final String UNDERLINE = "Underline";
    public static final String COURIER = "Courier";
    public static final String HELVETICA = "Helvetica";
    public static final String SYMBOL = "Symbol";
    public static final String TIMES_ROMAN = "Times Roman";
    public static final String ZAPFDINGBATS = "ZapfDingBats";
    protected int m_FontFamily;
    protected int m_FontFace;
    protected float m_Size;
    protected transient Font m_Font;

    public PdfFont() {
        this(HELVETICA, NORMAL, 12.0f);
    }

    public PdfFont(String family, String face, float size) {
        this(PdfFont.getFontFamily(family), PdfFont.getFontFace(face), size);
    }

    public PdfFont(String family, int face, float size) {
        this(PdfFont.getFontFamily(family), face, size);
    }

    public PdfFont(int family, int face, float size) {
        this.m_FontFamily = family;
        this.m_FontFace = face;
        this.m_Size = size;
        this.m_Font = null;
    }

    public PdfFont(String fontStr) {
        String str = fontStr;
        this.m_Size = Integer.parseInt(str.substring(str.lastIndexOf(45) + 1));
        str = str.substring(0, str.lastIndexOf(45));
        String attsStr = str.substring(str.lastIndexOf(45) + 1);
        String[] split = attsStr.split(",");
        str = str.substring(0, str.lastIndexOf(45));
        this.m_FontFace = 0;
        for (int i = 0; i < split.length; ++i) {
            this.m_FontFace |= PdfFont.getFontFace(split[i]);
        }
        this.m_FontFamily = PdfFont.getFontFamily(str);
    }

    public int getFontFamily() {
        return this.m_FontFamily;
    }

    public String getFontFamilyName() {
        if (this.m_FontFamily == Font.FontFamily.COURIER.ordinal()) {
            return COURIER;
        }
        if (this.m_FontFamily == Font.FontFamily.HELVETICA.ordinal()) {
            return HELVETICA;
        }
        if (this.m_FontFamily == Font.FontFamily.SYMBOL.ordinal()) {
            return SYMBOL;
        }
        if (this.m_FontFamily == Font.FontFamily.TIMES_ROMAN.ordinal()) {
            return TIMES_ROMAN;
        }
        if (this.m_FontFamily == Font.FontFamily.ZAPFDINGBATS.ordinal()) {
            return ZAPFDINGBATS;
        }
        return HELVETICA;
    }

    public int getFontFace() {
        return this.m_FontFace;
    }

    public String[] getFontFaces() {
        Vector<String> result = new Vector<String>();
        if ((this.m_FontFace & 1) == 1) {
            result.add(BOLD);
        }
        if ((this.m_FontFace & 2) == 2) {
            result.add(ITALIC);
        }
        if ((this.m_FontFace & 8) == 8) {
            result.add(STRIKETHRU);
        }
        if ((this.m_FontFace & 4) == 4) {
            result.add(UNDERLINE);
        }
        if (result.size() == 0) {
            result.add(NORMAL);
        }
        return result.toArray(new String[result.size()]);
    }

    public float getSize() {
        return this.m_Size;
    }

    public PdfFont getClone() {
        return new PdfFont(this.m_FontFamily, this.m_FontFace, this.m_Size);
    }

    public String toString() {
        Font font = this.toFont();
        String result = font.getFamilyname();
        result = result + "-" + Utils.flatten((String[])PdfFont.getFontFaces(font), (String)",");
        result = result + "-" + new Float(font.getSize()).intValue();
        return result;
    }

    public synchronized Font toFont() {
        return this.toFont(Color.BLACK);
    }

    public synchronized Font toFont(Color color) {
        if (this.m_Font == null) {
            this.m_Font = new Font(PdfFont.getFontFamilyEnum(this.m_FontFamily), this.m_Size, this.m_FontFace, new BaseColor(color));
        }
        return this.m_Font;
    }

    public java.awt.Font toJavaFont() {
        String name = this.m_FontFamily == Font.FontFamily.HELVETICA.ordinal() ? "SansSerif" : (this.m_FontFamily == Font.FontFamily.TIMES_ROMAN.ordinal() ? "Serif" : (this.m_FontFamily == Font.FontFamily.COURIER.ordinal() ? "Monospaced" : "Dialog"));
        int atts = 0;
        if ((this.m_FontFace & 1) == 1) {
            atts |= 1;
        }
        if ((this.m_FontFace & 2) == 2) {
            atts |= 2;
        }
        java.awt.Font result = new java.awt.Font(name, atts, (int)this.m_Size);
        return result;
    }

    public static int getFontFamily(String name) {
        int result = name.equals(COURIER) ? Font.FontFamily.COURIER.ordinal() : (name.equals(HELVETICA) ? Font.FontFamily.HELVETICA.ordinal() : (name.equals(SYMBOL) ? Font.FontFamily.SYMBOL.ordinal() : (name.equals(TIMES_ROMAN) ? Font.FontFamily.TIMES_ROMAN.ordinal() : (name.equals(ZAPFDINGBATS) ? Font.FontFamily.ZAPFDINGBATS.ordinal() : 0))));
        return result;
    }

    public static String getFontFamily(Font font) {
        return PdfFont.getFontFamily(font.getFamily().ordinal());
    }

    public static Font.FontFamily getFontFamilyEnum(int family) {
        if (family == Font.FontFamily.COURIER.ordinal()) {
            return Font.FontFamily.COURIER;
        }
        if (family == Font.FontFamily.HELVETICA.ordinal()) {
            return Font.FontFamily.HELVETICA;
        }
        if (family == Font.FontFamily.SYMBOL.ordinal()) {
            return Font.FontFamily.SYMBOL;
        }
        if (family == Font.FontFamily.TIMES_ROMAN.ordinal()) {
            return Font.FontFamily.TIMES_ROMAN;
        }
        if (family == Font.FontFamily.ZAPFDINGBATS.ordinal()) {
            return Font.FontFamily.ZAPFDINGBATS;
        }
        return Font.FontFamily.HELVETICA;
    }

    public static String getFontFamily(int family) {
        if (family == Font.FontFamily.COURIER.ordinal()) {
            return COURIER;
        }
        if (family == Font.FontFamily.HELVETICA.ordinal()) {
            return HELVETICA;
        }
        if (family == Font.FontFamily.SYMBOL.ordinal()) {
            return SYMBOL;
        }
        if (family == Font.FontFamily.TIMES_ROMAN.ordinal()) {
            return TIMES_ROMAN;
        }
        if (family == Font.FontFamily.ZAPFDINGBATS.ordinal()) {
            return ZAPFDINGBATS;
        }
        return HELVETICA;
    }

    public static int getFontFace(String name) {
        int result = name.equals(BOLD) ? 1 : (name.equals(ITALIC) ? 2 : (name.equals(STRIKETHRU) ? 8 : (name.equals(UNDERLINE) ? 4 : 0)));
        return result;
    }

    public static String[] getFontFaces(Font font) {
        Vector<String> result = new Vector<String>();
        if (font.isBold()) {
            result.add(BOLD);
        }
        if (font.isItalic()) {
            result.add(ITALIC);
        }
        if (font.isStrikethru()) {
            result.add(STRIKETHRU);
        }
        if (font.isUnderlined()) {
            result.add(UNDERLINE);
        }
        if (result.size() == 0) {
            result.add(NORMAL);
        }
        return result.toArray(new String[result.size()]);
    }
}

