/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.base.BaseString;
import adams.core.io.PdfFont;
import adams.core.option.OptionHandlingObject;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import java.awt.Color;
import java.io.File;
import java.io.Serializable;

public abstract class AbstractPdfProclet
extends OptionHandlingObject {
    private static final long serialVersionUID = -9041126884910193987L;
    public static final String MATCH_ALL_EXTENSION = "*";
    protected boolean m_PageBreakBefore;
    protected boolean m_PageBreakAfter;
    protected int m_NumFilesPerPage;
    protected boolean m_AddFilename;
    protected PdfFont m_FontFilename;
    protected Color m_ColorFilename;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("page-break-before", "pageBreakBefore", (Object)false);
        this.m_OptionManager.add("page-break-after", "pageBreakAfter", (Object)false);
        this.m_OptionManager.add("num-files", "numFilesPerPage", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("add-filename", "addFilename", (Object)false);
        this.m_OptionManager.add("font-filename", "fontFilename", (Object)new PdfFont("Helvetica", "Bold", 12.0f));
        this.m_OptionManager.add("color-filename", "colorFilename", (Object)Color.BLACK);
    }

    public abstract BaseString[] getExtensions();

    public void setPageBreakBefore(boolean value) {
        this.m_PageBreakBefore = value;
        this.reset();
    }

    public boolean getPageBreakBefore() {
        return this.m_PageBreakBefore;
    }

    public String pageBreakBeforeTipText() {
        return "If true, then a page-break is added before the content of the file is inserted.";
    }

    public void setPageBreakAfter(boolean value) {
        this.m_PageBreakAfter = value;
        this.reset();
    }

    public boolean getPageBreakAfter() {
        return this.m_PageBreakAfter;
    }

    public String pageBreakAfterTipText() {
        return "If true, then a page-break is added after the content of the file is inserted.";
    }

    public void setNumFilesPerPage(int value) {
        if (value >= -1) {
            this.m_NumFilesPerPage = value;
            this.reset();
        } else {
            this.getSystemErr().println("Number of files per page has to be at least 1 (or -1), provided: " + value);
        }
    }

    public int getNumFilesPerPage() {
        return this.m_NumFilesPerPage;
    }

    public String numFilesPerPageTipText() {
        return "The number of files to put on a page before adding an automatic page break; use -1 for unlimited.";
    }

    public void setAddFilename(boolean value) {
        this.m_AddFilename = value;
        this.reset();
    }

    public boolean getAddFilename() {
        return this.m_AddFilename;
    }

    public String addFilenameTipText() {
        return "Whether to add the file name before the actual file content as separate paragraph.";
    }

    public void setFontFilename(PdfFont value) {
        this.m_FontFilename = value;
        this.reset();
    }

    public PdfFont getFontFilename() {
        return this.m_FontFilename;
    }

    public String fontFilenameTipText() {
        return "The font to use for printing the file name header.";
    }

    public void setColorFilename(Color value) {
        this.m_ColorFilename = value;
        this.reset();
    }

    public Color getColorFilename() {
        return this.m_ColorFilename;
    }

    public String colorFilenameTipText() {
        return "The color to use for printing the file name header.";
    }

    protected boolean addFilename(Document doc, DocumentState state, File file) throws Exception {
        Paragraph para;
        boolean result = true;
        if (this.m_AddFilename && (result = doc.add((Element)(para = new Paragraph(file.getName() + "\n", this.m_FontFilename.toFont(this.m_ColorFilename)))))) {
            state.contentAdded();
        }
        return result;
    }

    protected boolean preProcess(Document doc, DocumentState state, File file) throws Exception {
        boolean result = true;
        if (this.m_PageBreakBefore) {
            result = state.newPage(doc);
        }
        return result;
    }

    protected abstract boolean doProcess(Document var1, DocumentState var2, File var3) throws Exception;

    protected boolean postProcess(Document doc, DocumentState state, File file) throws Exception {
        boolean result = true;
        if (this.m_PageBreakAfter || state.numCurrentFiles() == this.m_NumFilesPerPage) {
            result = doc.newPage();
            state.resetCurrentFiles();
        }
        return result;
    }

    public boolean canProcess(DocumentState state, File file) {
        boolean result = false;
        String extension = file.getName().replaceAll(".*\\.", "");
        for (BaseString ext : this.getExtensions()) {
            if (ext.stringValue().equals(MATCH_ALL_EXTENSION)) {
                result = true;
            } else if (ext.stringValue().equalsIgnoreCase(extension)) {
                result = true;
            }
            if (result) break;
        }
        return result;
    }

    public boolean process(Document doc, DocumentState state, File file) {
        boolean result;
        try {
            if (this.isDebugOn()) {
                this.debug("preProcess: " + file);
            }
            if (result = this.preProcess(doc, state, file)) {
                if (this.isDebugOn()) {
                    this.debug("doProcess: " + file);
                }
                result = this.doProcess(doc, state, file);
            }
            if (result) {
                state.addFile();
                if (this.isDebugOn()) {
                    this.debug("postProcess: " + file);
                }
                result = this.postProcess(doc, state, file);
            }
        }
        catch (Exception e) {
            result = false;
            this.getSystemErr().println("Failed to add file '" + file + "':");
            this.getSystemErr().printStackTrace((Throwable)e);
        }
        return result;
    }

    public static class DocumentState
    implements Serializable {
        private static final long serialVersionUID = 4076944821318913218L;
        protected boolean m_NewPageAdded;
        protected int m_TotalFiles;
        protected int m_CurrentFiles;

        public boolean newPage(Document doc) {
            boolean result = true;
            if (!this.isNewPage() && (result = doc.newPage())) {
                this.newPageAdded();
            }
            return result;
        }

        public void newPageAdded() {
            this.m_NewPageAdded = true;
        }

        public void contentAdded() {
            this.m_NewPageAdded = false;
        }

        public boolean isNewPage() {
            return this.m_NewPageAdded;
        }

        public void addFile() {
            ++this.m_TotalFiles;
            ++this.m_CurrentFiles;
        }

        public void resetCurrentFiles() {
            this.m_CurrentFiles = 0;
        }

        public int numTotalFiles() {
            return this.m_TotalFiles;
        }

        public int numCurrentFiles() {
            return this.m_CurrentFiles;
        }

        public String toString() {
            return "#total=" + this.numTotalFiles() + "#current=" + this.numCurrentFiles() + ", newPage=" + this.isNewPage();
        }
    }
}

