/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.pdf;

import adams.core.annotation.MixedCopyright;
import de.intarsys.cwt.awt.environment.CwtAwtGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.pdf.platform.cwt.rendering.CSPlatformRenderer;
import de.intarsys.tools.locator.ILocator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import javax.swing.JPanel;

@MixedCopyright
public class PDFCanvas
extends JPanel {
    private static final long serialVersionUID = -760870680991728999L;
    private PDDocument doc;
    private PDPage page;
    private Rectangle2D pageRect;
    private PDPageTree pageTree;
    private double scale = 1.0;

    public PDDocument getDoc() {
        return this.doc;
    }

    public PDPage getPage() {
        return this.page;
    }

    public int getPageCount() {
        return this.pageTree.getCount();
    }

    public int getPageIndex() {
        return this.getPage().getNodeIndex();
    }

    public PDPageTree getPageTree() {
        return this.pageTree;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public void paint(Graphics g) {
        if (this.page == null) {
            return;
        }
        CwtAwtGraphicsContext graphics = new CwtAwtGraphicsContext((Graphics2D)g);
        AffineTransform imgTransform = graphics.getTransform();
        imgTransform.scale(this.getScale(), -this.getScale());
        imgTransform.translate(-this.pageRect.getMinX(), -this.pageRect.getMaxY());
        graphics.setTransform(imgTransform);
        graphics.setBackgroundColor(Color.WHITE);
        graphics.fill((Shape)this.pageRect);
        CSContent content = this.page.getContentStream();
        if (content != null) {
            CSPlatformRenderer renderer = new CSPlatformRenderer(null, (IGraphicsContext)graphics);
            renderer.process(content, this.page.getResources());
        }
    }

    public void selectFirstPage() {
        this.setPage(this.pageTree.getFirstPage());
    }

    public void selectLastPage() {
        this.setPage(this.pageTree.getLastPage());
    }

    public void selectNextPage() {
        PDPage newPage = this.getPage().getNextPage();
        if (newPage == null) {
            return;
        }
        this.setPage(newPage);
    }

    public void selectPage(int index) {
        PDPage page = this.pageTree.getPageAt(index);
        if (page != null) {
            this.setPage(page);
        }
    }

    public void selectPreviousPage() {
        PDPage newPage = this.getPage().getPreviousPage();
        if (newPage == null) {
            return;
        }
        this.setPage(newPage);
    }

    public void setDoc(PDDocument doc) {
        this.doc = doc;
        this.setPageTree(this.getDoc().getPageTree());
        this.setPage(this.getPageTree().getFirstPage());
    }

    public void setLocator(ILocator locator) throws IOException, COSLoadException {
        PDDocument tempDoc = PDDocument.createFromLocator((ILocator)locator);
        this.setDoc(tempDoc);
    }

    public void setPage(PDPage page) {
        this.page = page;
        this.pageRect = page.getCropBox().toNormalizedRectangle();
        this.updateModel();
    }

    protected void setPageTree(PDPageTree pageTree) {
        this.pageTree = pageTree;
    }

    public void setScale(double pScale) {
        this.scale = (float)pScale;
        this.updateModel();
    }

    protected void updateModel() {
        int width = (int)(this.pageRect.getWidth() * this.getScale());
        int height = (int)(this.pageRect.getHeight() * this.getScale());
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
        this.repaint();
    }

    static {
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
    }
}

