/**
 * AbstractGlobalPHMMClassifierEvaluator.java
 * Copyright (C) 2009-2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.transformer;

import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.Token;
import adams.flow.source.GlobalSource;

/**
 * Ancestor for classifier evaluators that make use of a global PHMM classifier.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3444 $
 */
public abstract class AbstractGlobalPHMMClassifierEvaluator<T extends weka.classifiers.Classifier>
  extends AbstractWekaClassifierEvaluator {

  /** for serialization. */
  private static final long serialVersionUID = 9216099627972841132L;

  /** the name of the global PHMM classifier. */
  protected GlobalActorReference m_Classifier;

  /**
   * Adds options to the internal list of options.
   */
  public void defineOptions() {
    super.defineOptions();

    m_OptionManager.add(
	    "classifier", "classifier",
	    new GlobalActorReference("PHMMClassifier"));
  }

  /**
   * Sets the name of the global classifier to use.
   *
   * @param value	the name
   */
  public void setClassifier(GlobalActorReference value) {
    m_Classifier = value;
    reset();
  }

  /**
   * Returns the name of the global classifier in use.
   *
   * @return		the name
   */
  public GlobalActorReference getClassifier() {
    return m_Classifier;
  }

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public abstract String classifierTipText();

  /**
   * Returns a quick info about the actor, which will be displayed in the GUI.
   *
   * @return		null if no info available, otherwise short string
   */
  public String getQuickInfo() {
    String	variable;

    variable = getOptionManager().getVariableForProperty("classifier");

    if (variable != null)
      return variable;
    else if (m_Classifier != null)
      return m_Classifier.toString();
    else
      return null;
  }

  /**
   * Returns an instance of the global classifier.
   *
   * @return		the classifier
   */
  protected T getClassifierInstance() {
    GlobalSource	global;
    T			result;
    AbstractActor	actor;
    Token		token;

    result = null;

    global = new GlobalSource();
    global.setGlobalName(m_Classifier);
    global.setParent(getParent());
    if (global.setUp() == null) {
      global.execute();
      token = global.output();
      if (token != null) {
	result = (T) token.getPayload();
	actor  = global.getGlobalActor();
	global.wrapUp();
	global.cleanUp();
	// fix wrapUp/cleanUp of global actor, e.g., re-registering variable listeners
	if (actor != null)
	  actor.setUp();
      }
    }

    return result;
  }
}
