package adams.flow.transformer;

import adams.flow.source.RSource.DataType;
import adams.flow.standalone.RServe;

public class RTransformer
  extends AbstractTransformer {

  /** for serialization. */
  private static final long serialVersionUID = -2595028152021378207L;

  /** Script to pass to r*/
  protected String m_rScript;

  /**Data type of object returned from r script*/
  protected DataType m_returnType;

  /**Object returned from r*/
  protected Object m_returnedObject;

  public void defineOptions() {
    super.defineOptions();

    m_OptionManager.add(
	"r-Script", "rScript",
        "");

    m_OptionManager.add(
	"return-type", "returnType",
	DataType.Integer);
  }

  public void setReturnType(DataType val) {
    m_returnType = val;
    reset();
  }

  public DataType getReturnType() {
    return m_returnType;
  }

  public String returnTypeTipText() {
    return "Data type of returned object";
  }

  public void setRScript(String val) {
    m_rScript = val;
    reset();
  }

  public String getRScript() {
    return m_rScript;
  }

  public String rScriptTipText() {
    return "Script to pass into r";
  }

  public Class[] accepts() {
    Class[]	accepted = new Class[]{Integer.class,Integer[].class,Integer[][].class,
	Double.class,Double[].class,Double[][].class};
    return accepted;
  }

  public Class[] generates() {
    Class[]	generated = new Class[]{};

    switch (m_returnType) {
      case Integer:
	generated = new Class[]{Integer.class};
	break;

      case IntArray:
	generated = new Class[]{Integer[].class};
	break;

      case Int2DArray:
	generated = new Class[]{Integer[][].class};
	break;

      case String:
	generated = new Class[]{String.class};
	break;

      case StrArray:
	generated = new Class[]{String[].class};
	break;

      case Str2DArray:
	generated = new Class[]{Integer[][].class};
	break;

      case Double:
	generated = new Class[]{Double.class};
	break;

      case DubArray:
	generated = new Class[]{Double[].class};
	break;

      default:
	generated = new Class[]{Double[][].class};
	break;
    }
    return generated;
  }

  protected String doExecute() {
    RServe rs = new RServe();
    m_returnedObject = rs.doRequest(m_rScript);
    //		double[] dub = (double[])m_returnedObject;
    //		for(double d:dub) {
    //			System.out.println(d);
    //		}
    return "completed, with" + m_returnType;
  }

  @Override
  public String globalInfo() {
    return "Carries out an r command on the token passed in";
  }
}
