/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * RServe.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.standalone;

import org.rosuda.REngine.Rserve.RConnection;

public class RServe {

  RConnection r;
  public RServe() {
    r = getLocalRconnection();
  }

  public Object doRequest(String script) {
    Object returned = null;
    if (r != null) {
      try {
	returned = r.eval(script).asDoubles();
	r.close();
      }
      catch(Exception e) {
	e.printStackTrace();
      }
    }
    return returned;
  }


  private RConnection getLocalRconnection() {
    try {
      return new RConnection();
    }
    catch (Exception e) {
      //If we get this kind of error, it may be because Rserve is not running
      if (e.getMessage().equals("Cannot connect: Connection refused: connect")) {
	try {
	  //need to change this to the windows equivalent
	  //this is the unix version
	  // String rserveStartCommand = "R CMD Rserve --vanilla";
	  //windows version
	  if(adams.core.management.OS.isWindows()) {

	  }
	  else {

	  }
	  String rserveStartCommand = "C:\\Program Files\\R\\R-2.13.1\\bin\\i386\\Rserve.exe";
	  //do a blocking call to the shell command for starting Rserve
	  int exitValue = Runtime.getRuntime().exec(rserveStartCommand).waitFor();
	  //if it returned success, try connecting again
	  if (exitValue == 0)
	    return new RConnection();
	  //otherwise, Rserve is probably not installed
	  else
	    System.err.println("Could not start Rserve - is it installed properly? Shell command \""+rserveStartCommand+"\" exited with exit value "+exitValue+".");
	}
	catch (Exception e1) {
	  e1.printStackTrace();
	}
      }
      else
	e.printStackTrace();
    }
    return null;
  }
}