/**
 * UniformTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.data.random;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;

/**
 * Test class for the Uniform random number generator filter. Run from the command line with: <p/>
 * java adams.data.random.UniformTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2249 $
 */
public class UniformTest
  extends AbstractRandomNumberGeneratorTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public UniformTest(String name) {
    super(name);
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractRandomNumberGenerator[] getRegressionSetups() {
    Uniform[]	result;

    result = new Uniform[4];

    result[0] = new Uniform();

    result[1] = new Uniform();
    result[1].setMinValue(0.5);

    result[2] = new Uniform();
    result[2].setMaxValue(10.0);

    result[3] = new Uniform();
    result[3].setMinValue(5.0);
    result[3].setMaxValue(20.0);

    return result;
  }

  /**
   * Returns the test suite.
   *
   * @return		the suite
   */
  public static Test suite() {
    return new TestSuite(UniformTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
