/**
 * WeibullTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.data.random;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;

/**
 * Test class for the Weibull random number generator filter. Run from the command line with: <p/>
 * java adams.data.random.WeibullTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2249 $
 */
public class WeibullTest
  extends AbstractRandomNumberGeneratorTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public WeibullTest(String name) {
    super(name);
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractRandomNumberGenerator[] getRegressionSetups() {
    Weibull[]	result;

    result = new Weibull[4];

    result[0] = new Weibull();

    result[1] = new Weibull();
    result[1].setMean(3.2);

    result[2] = new Weibull();
    result[2].setStdev(2.1);

    result[3] = new Weibull();
    result[3].setMean(3.2);
    result[3].setStdev(2.1);

    return result;
  }

  /**
   * Returns the test suite.
   *
   * @return		the suite
   */
  public static Test suite() {
    return new TestSuite(WeibullTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
