/**
 * BetaTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.data.random;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;

/**
 * Test class for the Beta random number generator filter. Run from the command line with: <p/>
 * java adams.data.random.BetaTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2249 $
 */
public class BetaTest
  extends AbstractRandomNumberGeneratorTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public BetaTest(String name) {
    super(name);
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractRandomNumberGenerator[] getRegressionSetups() {
    Beta[]	result;

    result = new Beta[4];

    result[0] = new Beta();

    result[1] = new Beta();
    result[1].setA(3.2);

    result[2] = new Beta();
    result[2].setB(2.1);

    result[3] = new Beta();
    result[3].setA(3.2);
    result[3].setB(2.1);

    return result;
  }

  /**
   * Returns the test suite.
   *
   * @return		the suite
   */
  public static Test suite() {
    return new TestSuite(BetaTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
