/*
 * Decompiled with CFR 0.152.
 */
package adams.data.random;

import adams.data.random.AbstractSeededRandomNumberGenerator;
import adams.data.random.Random;

public class Beta
extends AbstractSeededRandomNumberGenerator<Double> {
    private static final long serialVersionUID = 8058404120296659028L;
    protected double m_A;
    protected double m_B;
    protected Random m_Random;

    public String globalInfo() {
        return "Generates random numbers from a Beta random variable.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("a", "a", (Object)1.0);
        this.m_OptionManager.add("b", "b", (Object)2.0);
    }

    public void reset() {
        super.reset();
        this.m_Random = null;
    }

    public void setA(double value) {
        this.m_A = value;
        this.reset();
    }

    public double getA() {
        return this.m_A;
    }

    public String aTipText() {
        return "The first parameter for the beta random variable.";
    }

    public void setB(double value) {
        this.m_B = value;
        this.reset();
    }

    public double getB() {
        return this.m_B;
    }

    public String bTipText() {
        return "The second parameter for the beta random variable.";
    }

    protected void check() {
        super.check();
        if (this.m_Random == null) {
            this.m_Random = new Random(this.m_Seed);
        }
    }

    protected Double doNext() {
        return this.m_Random.beta(this.m_A, this.m_B);
    }
}

