/*
 * Decompiled with CFR 0.152.
 */
package adams.data.random;

import adams.data.random.AbstractSeededRandomNumberGenerator;
import adams.data.random.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Uniform
extends AbstractSeededRandomNumberGenerator<Double> {
    private static final long serialVersionUID = 8058404120296659028L;
    protected double m_MinValue;
    protected double m_MaxValue;
    protected Random m_Random;

    public String globalInfo() {
        return "Generates random numbers from a uniform random variable.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-value", "minValue", (Object)0.0);
        this.m_OptionManager.add("max-value", "maxValue", (Object)1.0);
    }

    public void reset() {
        super.reset();
        this.m_Random = null;
    }

    public void setMinValue(double value) {
        this.m_MinValue = value;
        this.reset();
    }

    public double getMinValue() {
        return this.m_MinValue;
    }

    public String minValueTipText() {
        return "The smallest number that could be generated.";
    }

    public void setMaxValue(double value) {
        this.m_MaxValue = value;
        this.reset();
    }

    public double getMaxValue() {
        return this.m_MaxValue;
    }

    public String maxValueTipText() {
        return "The largest number that could be generated.";
    }

    protected void check() {
        super.check();
        if (this.getMinValue() >= this.getMaxValue()) {
            throw new IllegalStateException("MinValue must be smaller than MaxValue: MinValue=" + this.getMinValue() + ", MaxValue=" + this.getMaxValue());
        }
        if (this.m_Random == null) {
            this.m_Random = new Random(this.m_Seed);
        }
    }

    protected Double doNext() {
        return this.m_Random.uniform(this.m_MinValue, this.m_MaxValue);
    }
}

