/*
 * SpreadSheetCellTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.transformer;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.standalone.GlobalActors;
import adams.flow.sink.DumpFile;
import adams.flow.sink.GlobalSink;
import adams.flow.source.SingleFileSupplier;
import adams.test.TmpFile;

/**
 * Tests the SpreadSheetCell actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2934 $
 */
public class SpreadSheetCellTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public SpreadSheetCellTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method. Copies some resource files into
   * the tmp directory
   *
   * @throws Exception if an error occurs reading the example instances.
   */
  protected void setUp() throws Exception {
    super.setUp();

    m_TestHelper.copyResourceToTmp("iris.csv");
  }

  /**
   * Called by JUnit after each test method. Removes some tmp files again.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("iris.csv");
    m_TestHelper.deleteFileFromTmp("dumpfile.txt");

    super.tearDown();
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    DumpFile df = new DumpFile();
    df.setName("out");
    df.setAppend(true);
    df.setOutputFile(new TmpFile("dumpfile.txt"));

    GlobalActors ga = new GlobalActors();
    ga.setActors(new AbstractActor[]{
	df
    });

    SingleFileSupplier sfs = new SingleFileSupplier();
    sfs.setFile(new TmpFile("iris.csv"));

    SpreadSheetReader ssr = new SpreadSheetReader();

    SpreadSheetCell ssc1 = new SpreadSheetCell();
    ssc1.setRow("1");
    ssc1.setColumn("1");

    GlobalSink gs1 = new GlobalSink();
    gs1.setGlobalName(new GlobalActorReference("out"));

    Sequence seq1 = new Sequence();
    seq1.setActors(new AbstractActor[]{
	ssc1,
	gs1
    });

    SpreadSheetCell ssc2 = new SpreadSheetCell();
    ssc2.setRow("2");
    ssc2.setColumn("2");

    GlobalSink gs2 = new GlobalSink();
    gs2.setGlobalName(new GlobalActorReference("out"));

    Sequence seq2 = new Sequence();
    seq2.setActors(new AbstractActor[]{
	ssc2,
	gs2
    });

    SpreadSheetCell ssc3 = new SpreadSheetCell();
    ssc3.setRow("3");
    ssc3.setColumn("3");

    GlobalSink gs3 = new GlobalSink();
    gs3.setGlobalName(new GlobalActorReference("out"));

    Sequence seq3 = new Sequence();
    seq3.setActors(new AbstractActor[]{
	ssc3,
	gs3
    });

    Branch br = new Branch();
    br.setNumThreads(0);
    br.setBranches(new AbstractActor[]{
	seq1,
	seq2,
	seq3
    });

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{ga, sfs, ssr, br});

    return flow;
  }

  /**
   * Performs a regression test, comparing against previously generated output.
   */
  public void testRegression() {
    performRegressionTest(
	new TmpFile("dumpfile.txt"));
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(SpreadSheetCellTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
