/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.sendto;

import adams.core.io.AbstractSpreadSheetWriter;
import adams.core.io.SpreadSheet;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.sendto.AbstractSendToAction;
import java.io.File;
import javax.swing.JTable;

public class ExportAsSpreadsheet
extends AbstractSendToAction {
    private static final long serialVersionUID = -5286281737195775697L;

    public String getAction() {
        return "Export as spreadsheet";
    }

    public String getIconName() {
        return "spreadsheet.png";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class, JTable.class};
    }

    public String send(Object o) {
        String result = null;
        SpreadSheet sheet = null;
        if (o instanceof SpreadSheet) {
            sheet = (SpreadSheet)o;
        } else if (o instanceof JTable) {
            int i;
            sheet = new SpreadSheet();
            JTable table = (JTable)o;
            SpreadSheet.Row row = sheet.getHeaderRow();
            for (i = 0; i < table.getColumnCount(); ++i) {
                row.addCell("" + i).setContent(table.getColumnName(i));
            }
            for (int n = 0; n < table.getRowCount(); ++n) {
                row = sheet.addRow("" + n);
                for (i = 0; i < table.getColumnCount(); ++i) {
                    Object value = table.getValueAt(n, i);
                    if (value == null) continue;
                    row.addCell("" + i).setContent(value.toString());
                }
            }
        }
        if (sheet != null) {
            SpreadSheetFileChooser fileChooser = new SpreadSheetFileChooser();
            int retVal = fileChooser.showSaveDialog(null);
            if (retVal != 0) {
                result = "Export canceled by user!";
            }
            if (result == null) {
                try {
                    File file = fileChooser.getSelectedFile().getAbsoluteFile();
                    AbstractSpreadSheetWriter writer = fileChooser.getWriter();
                    if (!writer.write(sheet, file)) {
                        result = "Failed to export spreadsheet!";
                    }
                }
                catch (Exception e) {
                    String msg = "Failed to export spreadsheet: ";
                    result = msg + e;
                    this.getSystemErr().println(msg);
                    this.getSystemErr().printStackTrace((Throwable)e);
                }
            }
        } else {
            result = "Cannot export object as spreadsheet: " + o.getClass();
        }
        return result;
    }
}

