/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.AbstractSpreadSheetReader;
import adams.core.io.CsvSpreadSheetReader;
import adams.core.io.PlaceholderFile;
import adams.core.io.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class SpreadSheetReader
extends AbstractTransformer {
    private static final long serialVersionUID = -1585651878523228177L;
    protected AbstractSpreadSheetReader m_Reader;

    public String globalInfo() {
        return "Reads a spreadsheet file and forwards the content.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new CsvSpreadSheetReader());
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("reader");
        if (variable != null) {
            return variable;
        }
        if (this.m_Reader != null) {
            return this.m_Reader.getClass().getName();
        }
        return null;
    }

    public void setReader(AbstractSpreadSheetReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractSpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader for storing the spreadsheet.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        Object fileObj = this.m_InputToken.getPayload();
        File file = fileObj instanceof File ? (File)fileObj : new PlaceholderFile((String)fileObj);
        SpreadSheet content = this.m_Reader.read(file);
        if (content != null) {
            this.m_OutputToken = new Token((Object)content);
            this.m_InputToken = null;
        } else {
            result = "Error reading spreadsheet: " + file;
        }
        return result;
    }
}

