/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.AbstractSpreadSheetReader;
import adams.core.io.CsvSpreadSheetReader;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.SpreadSheetDisplay;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.SpreadSheetReader;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetDisplayTest
extends AbstractFlowTest {
    public SpreadSheetDisplayTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        super.tearDown();
    }

    public AbstractActor getActor() {
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("bolts.csv"));
        SpreadSheetReader ssr = new SpreadSheetReader();
        ssr.setReader((AbstractSpreadSheetReader)new CsvSpreadSheetReader());
        SpreadSheetDisplay ssd = new SpreadSheetDisplay();
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, ssr, ssd});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetDisplayTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetDisplayTest.runTest((Test)SpreadSheetDisplayTest.suite());
    }
}

