/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SpreadSheetPlotGeneratorTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.transformer;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.standalone.GlobalActors;
import adams.flow.sink.DumpFile;
import adams.flow.sink.GlobalSink;
import adams.flow.sink.SequencePlotter;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.SpreadSheetPlotGenerator;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.XYSequenceDotPaintlet;
import adams.gui.visualization.sequence.XYSequenceLinePaintlet;
import adams.test.TmpFile;

/**
 * Tests the SpreadSheetReader actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class SpreadSheetPlotGeneratorTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public SpreadSheetPlotGeneratorTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method. Copies some resource files into
   * the tmp directory
   *
   * @throws Exception if an error occurs reading the example instances.
   */
  protected void setUp() throws Exception {
    super.setUp();

    m_TestHelper.copyResourceToTmp("bolts.csv");
  }

  /**
   * Called by JUnit after each test method. Removes some tmp files again.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("bolts.csv");

    super.tearDown();
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    SingleFileSupplier sfs = new SingleFileSupplier();
    sfs.setFile(new TmpFile("bolts.csv"));

    SpreadSheetReader ssr = new SpreadSheetReader();

    SpreadSheetPlotGenerator plot1 = new SpreadSheetPlotGenerator();
    plot1.setPlotColumns("first,last");

    SequencePlotter sp1 = new SequencePlotter();
    sp1.setPaintlet(new XYSequenceLinePaintlet());

    Sequence seq1 = new Sequence();
    seq1.setActors(new AbstractActor[]{
	plot1,
	sp1
    });

    SpreadSheetPlotGenerator plot2 = new SpreadSheetPlotGenerator();
    plot2.setPlotColumns("first,last");
    plot2.setSortColumn("last");
    plot2.setSortDescending(true);

    SequencePlotter sp2 = new SequencePlotter();
    sp2.setPaintlet(new XYSequenceLinePaintlet());

    Sequence seq2 = new Sequence();
    seq2.setActors(new AbstractActor[]{
	plot2,
	sp2
    });

    SpreadSheetPlotGenerator plot3 = new SpreadSheetPlotGenerator();
    plot3.setPlotColumns("last_1,last");
    plot3.setXColumn("last");

    SequencePlotter sp3 = new SequencePlotter();
    XYSequenceDotPaintlet dot = new XYSequenceDotPaintlet();
    dot.setStrokeThickness(3.0f);
    sp3.setPaintlet(dot);

    Sequence seq3 = new Sequence();
    seq3.setActors(new AbstractActor[]{
	plot3,
	sp3
    });

    Branch br = new Branch();
    br.setNumThreads(0);
    br.setBranches(new AbstractActor[]{
	seq1,
	seq2,
	seq3
    });

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{sfs, ssr, br});

    return flow;
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(SpreadSheetPlotGeneratorTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
