/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayMean;
import adams.data.statistics.ArrayMedian;
import adams.data.statistics.MultiArrayStatistic;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.SpreadSheetReader;
import adams.flow.transformer.SpreadSheetStatistic;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetStatisticTest
extends AbstractFlowTest {
    public SpreadSheetStatisticTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        super.tearDown();
    }

    public AbstractActor getActor() {
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("bolts.csv"));
        SpreadSheetReader sr = new SpreadSheetReader();
        MultiArrayStatistic mas = new MultiArrayStatistic();
        mas.setSubStatistics(new AbstractArrayStatistic[]{new ArrayMedian(), new ArrayMean()});
        SpreadSheetStatistic is = new SpreadSheetStatistic();
        is.setDataType(SpreadSheetStatistic.DataType.COLUMN_BY_INDEX);
        is.setLocations(new BaseString[]{new BaseString("1"), new BaseString("last")});
        is.setStatistic((AbstractArrayStatistic)mas);
        DumpFile df = new DumpFile();
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.csv"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, sr, is, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.csv"));
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetStatisticTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetStatisticTest.runTest((Test)SpreadSheetStatisticTest.suite());
    }
}

