/**
 * TwitterUtils.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.core;

import twitter4j.TwitterFactory;
import adams.flow.standalone.TwitterConnection;

/**
 * Helper class for twitter-flow stuff.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3548 $
 */
public class TwitterUtils {

  /**
   * Returns the closest TwitterConnection actor, if available.
   *
   * @param actor	the actor start the search from (towards the root)
   * @return		the TwitterConnection actor, or null if none found
   */
  protected static TwitterConnection getTwitterConnectionActor(AbstractActor actor) {
    return (TwitterConnection) ActorUtils.findClosestType(actor, TwitterConnection.class, true);
  }

  /**
   * Returns the twitter connection object.
   *
   * @param actor	the actor to start the search from
   * @return		the connection, default connection object if no
   * 			TwitterConnection actor found
   */
  public static twitter4j.Twitter getTwitterConnection(AbstractActor actor) {
    twitter4j.Twitter	result;
    TwitterConnection	conn;

    conn = getTwitterConnectionActor(actor);
    if (conn == null)
      result = new TwitterFactory().getInstance();
    else
      result = conn.getTwitterConnection();

    return result;
  }

  /**
   * Returns the twitter stream connection object.
   *
   * @return		the stream connection, null if no TwitterConnection
   * 			actor found
   */
  public static twitter4j.TwitterStream getTwitterStreamConnection(AbstractActor actor) {
    twitter4j.TwitterStream	result;
    TwitterConnection		conn;

    result = null;
    conn   = getTwitterConnectionActor(actor);
    if (conn != null)
      result = conn.getTwitterStreamConnection();

    return result;
  }
}
