/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * TwitterUtils.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.core;

import twitter4j.TwitterFactory;
import adams.flow.standalone.TwitterConnection;

/**
 * Helper class for twitter-flow stuff.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class TwitterUtils {

  /**
   * Returns the closest TwitterConnection actor, if available.
   *
   * @param actor	the actor start the search from (towards the root)
   * @return		the TwitterConnection actor, or null if none found
   */
  protected static TwitterConnection getTwitterConnectionActor(AbstractActor actor) {
    return (TwitterConnection) ActorUtils.findClosestType(actor, TwitterConnection.class, true);
  }

  /**
   * Returns the twitter connection object.
   *
   * @param actor	the actor to start the search from
   * @return		the connection, default connection object if no
   * 			TwitterConnection actor found
   */
  public static twitter4j.Twitter getTwitterConnection(AbstractActor actor) {
    twitter4j.Twitter	result;
    TwitterConnection	conn;

    conn = getTwitterConnectionActor(actor);
    if (conn == null)
      result = new TwitterFactory().getInstance();
    else
      result = conn.getTwitterConnection();

    return result;
  }

  /**
   * Returns the twitter stream connection object.
   *
   * @return		the stream connection, null if no TwitterConnection
   * 			actor found
   */
  public static twitter4j.TwitterStream getTwitterStreamConnection(AbstractActor actor) {
    twitter4j.TwitterStream	result;
    TwitterConnection		conn;

    result = null;
    conn   = getTwitterConnectionActor(actor);
    if (conn != null)
      result = conn.getTwitterStreamConnection();

    return result;
  }
}
