/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.probabilityplot;

import adams.core.Index;
import adams.core.base.BaseRegExp;
import adams.data.statistics.StatUtils;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.ParameterPanel;
import adams.gui.event.PaintListener;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.core.IndexSet;
import adams.gui.visualization.stats.paintlet.AbstractProbabilityPaintlet;
import adams.gui.visualization.stats.paintlet.Normal;
import adams.gui.visualization.stats.probabilityplot.ProbabilityPlotPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.core.Instances;

public class ProbabilityPlot
extends PaintablePanel {
    private static final long serialVersionUID = 5997080502859878659L;
    protected Instances m_Instances;
    protected ProbabilityPlotPanel m_Plot;
    protected GenericObjectEditorPanel m_PanelRegression;
    protected AbstractProbabilityPaintlet m_val;
    protected AbstractProbabilityPaintlet m_def;
    protected int m_Index;
    protected boolean m_Line;
    protected ParameterPanel m_OptionPanel;
    protected JCheckBox line;
    protected JCheckBox grid;
    protected boolean m_Grid;
    protected JLabel m_Mean;
    protected JLabel m_Std;
    protected BaseRegExp m_AttReg;
    protected Index m_Indx;

    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    public void prepareUpdate() {
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    protected boolean canPaint(Graphics g) {
        return this.m_Plot != null && this.m_Instances != null;
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        this.m_Index = this.m_Instances.numAttributes() - 1;
    }

    public void reset() {
        int temp = -1;
        if ((temp = IndexSet.getIndex(this.m_AttReg, this.m_Indx, this.m_Instances, temp)) == -1) {
            temp = 0;
            System.err.println("changed to 0");
        }
        this.m_Index = temp;
        this.m_Plot.reset();
        this.m_val.setPanel(this);
        this.m_val.setAxis();
        this.m_val.setIndex(this.m_Index);
        this.m_val.setInstances(this.m_Instances);
        DecimalFormat df = new DecimalFormat("#.##");
        this.m_Mean.setText("Mean: " + df.format(StatUtils.mean((double[])this.m_Instances.attributeToDoubleArray(this.m_Index))));
        this.m_Std.setText("Std dev: " + df.format(StatUtils.stddev((double[])this.m_Instances.attributeToDoubleArray(this.m_Index), (boolean)false)));
        this.line.setEnabled(this.m_val.hasFitLine());
        if (this.m_val.hasFitLine()) {
            this.changeLine();
        }
        this.repaint();
        this.validate();
    }

    private void changeRegression() {
        this.removePaintlet(this.m_val);
        this.m_val = (AbstractProbabilityPaintlet)((Object)this.m_PanelRegression.getCurrent());
        this.m_val.setPanel(this);
        this.m_val.setAxis();
        this.m_val.setIndex(this.m_Index);
        this.m_val.setInstances(this.m_Instances);
        this.line.setEnabled(this.m_val.hasFitLine());
        if (this.m_val.hasFitLine()) {
            this.m_val.setLine(this.m_Line);
        }
        this.revalidate();
        this.repaint();
    }

    public void setRegression(AbstractProbabilityPaintlet val) {
        this.m_PanelRegression.setCurrent((Object)val);
        this.changeRegression();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Plot = new ProbabilityPlotPanel();
        this.m_Plot.addPaintListener((PaintListener)this);
        this.m_OptionPanel = new ParameterPanel();
        BaseSplitPane split = new BaseSplitPane(1);
        JPanel middle = new JPanel(new BorderLayout());
        middle.add((Component)((Object)this.m_Plot), "Center");
        JPanel key = new JPanel();
        key.setLayout(new BoxLayout(key, 1));
        this.m_Mean = new JLabel("");
        this.m_Std = new JLabel("");
        key.add(this.m_Mean);
        key.add(this.m_Std);
        key.setBackground(Color.WHITE);
        key.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JPanel east = new JPanel(new BorderLayout());
        east.add((Component)key, "North");
        middle.add((Component)east, "East");
        split.setLeftComponent((Component)middle);
        JPanel hold = new JPanel(new BorderLayout());
        hold.add((Component)this.m_OptionPanel, "North");
        split.setRightComponent((Component)hold);
        hold.setPreferredSize(new Dimension(600, 0));
        split.setOneTouchExpandable(true);
        split.setResizeWeight(1.0);
        this.add((Component)split, "Center");
        this.line = new JCheckBox();
        if (this.m_val != null) {
            this.line.setEnabled(this.m_val.hasFitLine());
        }
        this.grid = new JCheckBox();
        this.line.setSelected(false);
        this.grid.setSelected(false);
        JPanel gridPanel = new JPanel();
        this.m_def = this.m_val == null ? new Normal() : this.m_val;
        this.m_PanelRegression = new GenericObjectEditorPanel(AbstractProbabilityPaintlet.class, (Object)this.m_def, true);
        this.m_PanelRegression.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ProbabilityPlot.this.changeRegression();
                ProbabilityPlot.this.changeGrid();
            }
        });
        this.grid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProbabilityPlot.this.m_Grid = ((JCheckBox)arg0.getSource()).isSelected();
                ProbabilityPlot.this.changeGrid();
            }
        });
        this.line.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent arg0) {
                ProbabilityPlot.this.m_Line = ((JCheckBox)arg0.getSource()).isSelected();
                if (ProbabilityPlot.this.m_val.hasFitLine()) {
                    ProbabilityPlot.this.changeLine();
                }
            }
        });
        this.m_OptionPanel.addParameter("Regression", (Component)this.m_PanelRegression);
        this.m_OptionPanel.addParameter("display grid", (Component)this.grid);
        this.m_OptionPanel.addParameter("display best fit line", (Component)this.line);
    }

    private void changeGrid() {
        this.m_Plot.setGridColor(Color.LIGHT_GRAY);
        this.m_Plot.getAxis(Axis.LEFT).setShowGridLines(this.m_Grid);
        this.m_Plot.getAxis(Axis.BOTTOM).setShowGridLines(this.m_Grid);
        this.m_Plot.repaint();
        this.m_Plot.revalidate();
    }

    private void changeLine() {
        this.m_val.setLine(this.m_Line);
        this.repaint();
    }

    public void setGrid(boolean val) {
        this.m_Grid = val;
        this.grid.setSelected(val);
        this.changeGrid();
    }

    public void setRegressionLine(boolean val) {
        this.m_Line = val;
        this.line.setSelected(val);
    }

    public void setAttIndex(Index val) {
        this.m_Indx = val;
    }

    public void setAttReg(BaseRegExp val) {
        this.m_AttReg = val;
    }
}

