/*
 * HistogramPanel.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.stats.histogram;

import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.axis.Visibility;
import adams.gui.visualization.core.plot.Axis;

/**
 * Panel for displaying the histogram data.
 *
 * @author msf8
 * @version $Revision: 3270 $
 */
public class HistogramPanel
extends PlotPanel{

  /** for serialization */
  private static final long serialVersionUID = -5092764988729474925L;

  protected void initGUI() {
    super.initGUI();
    setAxisVisibility(Axis.LEFT, Visibility.VISIBLE);
    setAxisVisibility(Axis.BOTTOM, Visibility.VISIBLE);
    m_AxisLeft.setNumberFormat("#.##");
    setPanningEnabled(false);
    setZoomingEnabled(false);
    m_AxisLeft.setTopMargin(0.05);
  }
}