/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.core;

import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.supervised.instance.Resample;

public class SubSample {
    protected Instances m_Instances;
    protected double m_Percentage;

    public SubSample(Instances inst, double percent) {
        this.m_Instances = inst;
        this.m_Percentage = percent;
    }

    public Instances sample() throws Exception {
        this.m_Instances.setClassIndex(this.m_Instances.numAttributes() - 1);
        int seed = 42;
        Resample filter = null;
        if (this.m_Instances.classAttribute().isNominal()) {
            Resample resampleNom = new Resample();
            resampleNom.setRandomSeed(seed);
            resampleNom.setSampleSizePercent(this.m_Percentage);
            filter = resampleNom;
        } else {
            weka.filters.unsupervised.instance.Resample resampleOther = new weka.filters.unsupervised.instance.Resample();
            resampleOther.setRandomSeed(seed);
            resampleOther.setSampleSizePercent(this.m_Percentage);
            filter = resampleOther;
        }
        filter.setInputFormat(this.m_Instances);
        Instances sample = Filter.useFilter((Instances)this.m_Instances, (Filter)filter);
        return sample;
    }
}

