/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * VersusFit.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.stats.fourinone;

import java.awt.BorderLayout;
import java.awt.Graphics;

import weka.core.Instances;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.stats.paintlet.VsFitPaintlet;

/**
 * Class that displays a versus fit graph. Plotting the residuals on the
 * y axis and the predicted value on the x axis.
 *
 * @author msf8
 * @version $Revision: 4584 $
 */
public class VersusFit
extends PaintablePanel{

  /** for serialization */
  private static final long serialVersionUID = 2542241196305925848L;

  /** Instances containing the data */
  protected Instances m_Instances;

  /** Panel for displaying the data */
  protected VersusFitPanel m_Plot;

  /** Paintlet for plotting */
  protected VsFitPaintlet m_val;

  /**Options for the plot */
  protected VersusFitOptions m_VsFitOptions;

  /**Index of the residuals attribute in the instances */
  protected int m_Index;

  /** Index of the predicted attribute in the instances */
  protected int m_PredInd;

  /**
   * Set the options for this versus fit
   * @param val			Versusfitoptions object containing the options
   */
  public void setOptions(VersusFitOptions val) {
    m_VsFitOptions = val;
  }

  public PlotPanel getPlot() {
    return m_Plot;
  }

  public void prepareUpdate() {
  }

  protected boolean canPaint(Graphics g) {
    return(m_Plot != null);
  }

  /**
   * get the instances being plotted
   * @return		Instances for plotting
   */
  public Instances getInstances() {
    return m_Instances;
  }

  /**
   * Set the instances to be plotted
   * @param inst		Instances for plotting
   */
  public void setInstances(Instances inst) {
    m_Instances = inst;
  }

  /**
   * Called by the class that creates this versusfit once the fields
   * have been set
   */
  public void reset() {
    m_val = m_VsFitOptions.m_Val;
    m_val.setPanel(this);
    m_val.setInstances(m_Instances);
    m_val.setIndices(m_Index, m_PredInd);
    m_val.setRepaintOnChange(true);
  }

  protected void initGUI() {
    super.initGUI();
    setLayout(new BorderLayout());
    m_Plot = new VersusFitPanel();
    m_Plot.addPaintListener(this);
    add(m_Plot, BorderLayout.CENTER);
    m_val = new VsFitPaintlet();
    repaint();
  }

  /**
   * Set the index of the residuals attribute in the instances
   */
  public void setIndices(int res, int pred) {
    m_Index = res;
    m_PredInd = pred;
  }
}