/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * NormalPlotOptions.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.stats.probabilityplot;

import adams.core.option.AbstractOptionHandler;

/**
 <!-- globalinfo-start -->
 * Class for setting the options for the normal probability plot
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D &lt;int&gt; (property: debugLevel)
 * &nbsp;&nbsp;&nbsp;The greater the number the more additional info the scheme may output to
 * &nbsp;&nbsp;&nbsp;the console (0 = off).
 * &nbsp;&nbsp;&nbsp;default: 0
 * &nbsp;&nbsp;&nbsp;minimum: 0
 * </pre>
 *
 * <pre>-regression-line (property: regLine)
 * &nbsp;&nbsp;&nbsp;Display a linear regression line overlay
 * </pre>
 *
 <!-- options-end -->
 *
 * @author msf8
 * @version $Revision: 4584 $
 *
 */
public class NormalPlotOptions
extends AbstractOptionHandler{

  /** for serialization */
  private static final long serialVersionUID = -4737656972085433346L;

  /**Whether to display a regression diagonal line */
  protected boolean m_RegLine;

  public String globalInfo() {
    return "Class for setting the options for the normal probability plot";
  }

  public void defineOptions() {
    super.defineOptions();

    //whether to display a regression line
    m_OptionManager.add(
	"regression-line", "regLine", true);
  }

  /**
   * Set whether a regression line should be drawn
   * @param val		True if regression line drawn
   */
  public void setRegLine(boolean val) {
    m_RegLine = val;
  }

  /**
   * Get whether a regression line should be drawn
   * @return
   */
  public boolean getRegLine() {
    return m_RegLine;
  }

  /**
   * Tip text for the regression line property
   * @return			String describing the property
   */
  public String regLineTipText() {
    return "Display a linear regression line overlay";
  }
}