/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * VersusOrder.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.stats.fourinone;

import java.awt.BorderLayout;
import java.awt.Graphics;

import weka.core.Instances;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.stats.paintlet.VsOrderPaintlet;

/**
 * Class that creates a versus order plot with the residuals
 * on the y axis and the position in the data on the x axis.
 *
 * @author msf8
 * @version $Revision: 4584 $
 */
public class VersusOrder
extends PaintablePanel{

  /** for serialization */
  private static final long serialVersionUID = 6182760237927361108L;

  /** Instances containing the data */
  protected Instances m_Instances;

  /**Panel for displaying the data */
  protected VersusOrderPanel m_Plot;

  /**Paintlet for plotting the data */
  protected VsOrderPaintlet m_Val;

  /**Options for the vsorder plot */
  protected VersusOrderOptions m_VsOrderOptions;

  /** index of the residuals attribute within the instances */
  protected int m_Index;

  /**
   * Set the options for the versus order
   * @param val			VersusOrderoptions object containing all the options for this versus order plot
   */
  public void setOptions(VersusOrderOptions val) {
    m_VsOrderOptions = val;
  }
  public PlotPanel getPlot() {
    return m_Plot;
  }

  public void prepareUpdate() {
  }

  protected boolean canPaint(Graphics g) {
    return(m_Plot != null);
  }

  /**
   * Get the instances for this versus order
   * @return			Instances for this plot
   */
  public Instances getInstances() {
    return m_Instances;
  }

  /**
   * Set the instances for this versus order
   * @param inst				Instances for this plot
   */
  public void setInstances(Instances inst) {
    m_Instances = inst;
  }

  /**
   * Called by the class that creates this versus order plot
   * once the fields have been set
   */
  public void reset() {
    m_Val = m_VsOrderOptions.m_Val;
    m_Val.setPanel(this);
    m_Val.setInstances(m_Instances);
    m_Val.setIndex(m_Index);
    m_Val.setRepaintOnChange(true);
  }

  protected void initGUI() {
    super.initGUI();
    setLayout(new BorderLayout());
    m_Plot = new VersusOrderPanel();
    m_Plot.addPaintListener(this);
    add(m_Plot, BorderLayout.CENTER);
    m_Val = new VsOrderPaintlet();
    repaint();
  }

  /**
   * Set the index of the residuals attribute within the instances
   * @param val
   */
  public void setIndex(int val) {
    m_Index = val;
  }
}