/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.data.statistics.StatUtils;
import adams.gui.visualization.stats.paintlet.AbstractZScorePaintlet;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class ZScoreCross
extends AbstractZScorePaintlet {
    private static final long serialVersionUID = 6710459160837483521L;

    public String globalInfo() {
        return "paintlet for plotting cross error points on the z score graph whose size depends on the difference between x and y values";
    }

    protected void drawData(Graphics g) {
        super.drawData(g);
        double mean = StatUtils.mean((double[])this.m_Data);
        double max = Math.max(StatUtils.max((double[])this.m_Data) - mean, mean - StatUtils.min((double[])this.m_Data));
        for (int i = 0; i < this.m_Data.length; ++i) {
            int posX = this.m_AxisBottom.valueToPos((double)i);
            int posY = this.m_AxisLeft.valueToPos(this.m_Data[i]);
            int crossSize = (int)((this.m_Data[i] - mean) / max * 20.0);
            int halfCross = crossSize / 2;
            g.setColor(this.m_Color);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
            g2d.drawLine(posX - halfCross, posY - halfCross, posX + halfCross, posY + halfCross);
            g2d.drawLine(posX - halfCross, posY + halfCross, posX + halfCross, posY - halfCross);
            if (i + 1 >= this.m_Data.length) continue;
            int posX2 = this.m_AxisBottom.valueToPos((double)(i + 1));
            int posY2 = this.m_AxisLeft.valueToPos(this.m_Data[i + 1]);
            g.setColor(this.m_LineColor);
            g.drawLine(posX, posY, posX2, posY2);
        }
    }
}

