/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.scatterplot;

import adams.core.Index;
import adams.core.base.BaseRegExp;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.ParameterPanel;
import adams.gui.event.PaintListener;
import adams.gui.goe.GenericArrayEditorPanel;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.stats.core.IndexSet;
import adams.gui.visualization.stats.paintlet.AbstractScatterPlotPaintlet;
import adams.gui.visualization.stats.paintlet.ScatterPaintletCircle;
import adams.gui.visualization.stats.scatterplot.AbstractScatterPlot;
import adams.gui.visualization.stats.scatterplot.AbstractScatterPlotOverlay;
import adams.gui.visualization.stats.scatterplot.ScatterPlotPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.core.Attribute;
import weka.core.Instances;

public class ScatterPlot
extends AbstractScatterPlot {
    private static final long serialVersionUID = -7798200657432959204L;
    protected BaseRegExp m_XIndexReg;
    protected Index m_XInd;
    protected BaseRegExp m_YIndexReg;
    protected Index m_YInd;
    protected JComboBox m_AttY;
    protected JComboBox m_AttX;
    protected DefaultComboBoxModel m_ComboBoxX;
    protected DefaultComboBoxModel m_ComboBoxY;
    protected GenericArrayEditorPanel m_PanelOverlay;
    protected GenericObjectEditorPanel m_PanelPaintlet;
    protected AbstractScatterPlotOverlay[] m_Default;
    protected AbstractScatterPlotPaintlet m_Def;

    protected void initialize() {
        super.initialize();
        this.m_XIndex = 0;
        this.m_YIndex = 0;
        this.m_XIndexReg = new BaseRegExp();
        this.m_YIndexReg = new BaseRegExp();
        this.m_XInd = new Index();
        this.m_YInd = new Index();
    }

    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    public void reset() {
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            this.m_ComboBoxX.addElement(this.m_Instances.attribute(i).name());
            this.m_ComboBoxY.addElement(this.m_Instances.attribute(i).name());
        }
        int temp = -1;
        if ((temp = IndexSet.getIndex(this.m_XIndexReg, this.m_XInd, this.m_Instances, temp)) == -1) {
            temp = 0;
            System.err.println("changed to 0");
        }
        this.m_XIndex = temp;
        temp = -1;
        if ((temp = IndexSet.getIndex(this.m_YIndexReg, this.m_YInd, this.m_Instances, temp)) == -1) {
            temp = 0;
            System.err.println("changed to 0");
        }
        this.m_YIndex = temp;
        this.m_AttY.setSelectedIndex(this.m_YIndex);
        this.m_AttX.setSelectedIndex(this.m_XIndex);
        if (this.m_Array == null) {
            this.m_Array = new AbstractScatterPlotOverlay[0];
        }
        this.m_Val.setPanel(this);
        this.m_Val.setInstances(this.m_Instances);
        this.change();
    }

    private void changeOverlay() {
        int i;
        this.removeOverlays();
        int len = ((AbstractScatterPlotOverlay[])this.m_PanelOverlay.getCurrent()).length;
        this.m_Array = new AbstractScatterPlotOverlay[len];
        for (i = 0; i < len; ++i) {
            this.m_Array[i] = ((AbstractScatterPlotOverlay[])this.m_PanelOverlay.getCurrent())[i].shallowCopy(true);
        }
        for (i = 0; i < this.m_Array.length; ++i) {
            AbstractScatterPlotOverlay temp = this.m_Array[i];
            temp.inst(this.m_Instances);
            temp.setParent(this);
            temp.setUp();
        }
        this.repaint();
    }

    private void changePaintlet() {
        this.removePaintlet(this.m_Val);
        this.m_Val = (AbstractScatterPlotPaintlet)((Object)this.m_PanelPaintlet.getCurrent());
        this.m_Val.setPanel(this);
        this.m_Val.setY_Index(this.m_YIndex);
        this.m_Val.setX_Index(this.m_XIndex);
        this.m_Val.setInstances(this.m_Instances);
        this.change();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Plot = new ScatterPlotPanel();
        this.m_Plot.addPaintListener((PaintListener)this);
        ParameterPanel optionPanel = new ParameterPanel();
        BaseSplitPane splitPane = new BaseSplitPane(1);
        splitPane.setLeftComponent((Component)((Object)this.m_Plot));
        JPanel hold = new JPanel(new BorderLayout());
        hold.add((Component)optionPanel, "North");
        splitPane.setRightComponent((Component)hold);
        splitPane.setResizeWeight(1.0);
        splitPane.setOneTouchExpandable(true);
        this.add((Component)splitPane, "Center");
        hold.setPreferredSize(new Dimension(600, 0));
        this.m_ComboBoxX = new DefaultComboBoxModel();
        this.m_ComboBoxY = new DefaultComboBoxModel();
        this.m_AttY = new JComboBox(this.m_ComboBoxY);
        this.m_AttX = new JComboBox(this.m_ComboBoxX);
        AttYListener listenY = new AttYListener(this);
        this.m_AttY.addItemListener(listenY);
        AttXListener listenX = new AttXListener(this);
        this.m_AttX.addItemListener(listenX);
        if (this.m_Val == null) {
            this.m_Def = new ScatterPaintletCircle();
            this.m_Val = new ScatterPaintletCircle();
        } else {
            this.m_Def = this.m_Val;
        }
        this.m_PanelPaintlet = new GenericObjectEditorPanel(AbstractScatterPlotPaintlet.class, (Object)this.m_Def, true);
        this.m_PanelPaintlet.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ScatterPlot.this.changePaintlet();
            }
        });
        this.m_Array = new AbstractScatterPlotOverlay[0];
        this.m_Default = new AbstractScatterPlotOverlay[0];
        this.m_PanelOverlay = new GenericArrayEditorPanel((Object)this.m_Default);
        this.m_PanelOverlay.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ScatterPlot.this.changeOverlay();
            }
        });
        this.m_Plot.setBorder(BorderFactory.createLineBorder(Color.black));
        optionPanel.addParameter("Y attribute", (Component)this.m_AttY);
        optionPanel.addParameter("X attribute", (Component)this.m_AttX);
        optionPanel.addParameter("Overlays", (Component)this.m_PanelOverlay);
        optionPanel.addParameter("Paintlet", (Component)this.m_PanelPaintlet);
    }

    public Index getX_Ind() {
        return this.m_XInd;
    }

    public void setX_Ind(Index val) {
        this.m_XInd = val;
    }

    public Index getY_Ind() {
        return this.m_YInd;
    }

    public void setY_Ind(Index val) {
        this.m_YInd = val;
    }

    public void setX_IndexReg(BaseRegExp val) {
        this.m_XIndexReg = val;
    }

    public BaseRegExp getX_IndexReg() {
        return this.m_XIndexReg;
    }

    public void setY_IndexReg(BaseRegExp val) {
        this.m_YIndexReg = val;
    }

    public BaseRegExp getY_IndexReg() {
        return this.m_YIndexReg;
    }

    public void setOverlays(AbstractScatterPlotOverlay[] val) {
        this.m_PanelOverlay.setCurrent((Object)val);
        this.changeOverlay();
    }

    public AbstractScatterPlotOverlay[] getOverlays() {
        return this.m_Array;
    }

    public AbstractScatterPlotPaintlet getPaintlet() {
        return this.m_Val;
    }

    public void setPaintlet(AbstractScatterPlotPaintlet val) {
        this.m_PanelPaintlet.setCurrent((Object)val);
        this.changePaintlet();
    }

    public void change() {
        if (this.m_Instances != null) {
            this.m_Plot.setinstances(this.m_Instances);
        }
        this.m_Plot.setX(this.m_XIndex);
        this.m_Plot.setY(this.m_YIndex);
        this.m_Plot.reset();
        this.m_Val.setX_Index(this.m_XIndex);
        this.m_Val.setY_Index(this.m_YIndex);
        this.m_Val.setInstances(this.m_Instances);
        this.update();
    }

    public void prepareUpdate() {
        for (int i = 0; i < this.m_Array.length; ++i) {
            if (this.m_Array[i].getPaintlet() == null) continue;
            this.m_Array[i].getPaintlet().parameters(this.m_Instances, this.m_XIndex, this.m_YIndex);
            if (this.m_Array[i].getPaintlet().getCalculated()) continue;
            this.m_Array[i].getPaintlet().calculate();
        }
    }

    protected class AttXListener
    implements ItemListener {
        ScatterPlot m_parent;

        public AttXListener(ScatterPlot parent) {
            this.m_parent = parent;
        }

        public void itemStateChanged(ItemEvent arg0) {
            Instances inst = this.m_parent.getInstances();
            if (arg0.getStateChange() == 1) {
                String item = (String)arg0.getItem();
                Attribute chose = inst.attribute(item);
                for (int t = 0; t < inst.numAttributes(); ++t) {
                    if (inst.attribute(t) != chose) continue;
                    for (int i = 0; i < ScatterPlot.this.m_Array.length; ++i) {
                        ScatterPlot.this.m_Array[i].getPaintlet().setCalculated(false);
                    }
                    ScatterPlot.this.m_XIndex = t;
                    ScatterPlot.this.change();
                    break;
                }
            }
        }
    }

    protected class AttYListener
    implements ItemListener {
        ScatterPlot m_parent;

        public AttYListener(ScatterPlot parent) {
            this.m_parent = parent;
        }

        public void itemStateChanged(ItemEvent arg0) {
            Instances inst = this.m_parent.getInstances();
            int ind = this.m_parent.getY_Index();
            if (arg0.getStateChange() == 1) {
                String item = (String)arg0.getItem();
                Attribute chose = inst.attribute(item);
                for (int t = 0; t < inst.numAttributes(); ++t) {
                    if (inst.attribute(t) != chose) continue;
                    for (int i = 0; i < ScatterPlot.this.m_Array.length; ++i) {
                        ScatterPlot.this.m_Array[i].getPaintlet().setCalculated(false);
                    }
                    ScatterPlot.this.m_YIndex = t;
                    ScatterPlot.this.change();
                    break;
                }
            }
        }
    }
}

