/*
 * Point.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.stats.core;

import java.io.Serializable;

/**
 * Class for points that contain a double x and y value, use for sorting.
 *
 * @author msf8
 * @version $Revision: 3270 $
 */
public class Point
implements Comparable, Serializable {

  /** for serialization */
  protected static final long serialVersionUID = 7854204648857399392L;

  /** x value of the point */
  protected double m_X;

  /** y value of the point */
  protected double m_Y;

  /**
   * Constructor
   * @param x		x value
   * @param y		y value
   */
  public Point(double x, double y)
  {
    m_X = x;
    m_Y = y;
  }

  /**
   * Compares this point object to the parameter depending on the m_X fields
   * @param obj			Point to compare against this point
   */
  public int compareTo(Object obj) {
    Point p = (Point)obj;
    if(this.m_X > p.m_X)
      return 1;
    else if(this.m_X == p.m_X)
      return 0;
    else
      return -1;
  }
  /**
   * Get the x value of the point
   * @return		x value
   */
  public double getX() {
    return m_X;
  }
  /**
   * get the y value of the point
   * @return		y value
   */
  public double getY()	{
    return m_Y;
  }
}