/*
 * VersusFitOptions.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.stats.fourinone;

import adams.core.option.OptionHandlingObject;
import adams.gui.visualization.stats.paintlet.VsFitPaintlet;

/**
 <!-- globalinfo-start -->
 * Class that contains options for the versusfit plot
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D &lt;int&gt; (property: debugLevel)
 * &nbsp;&nbsp;&nbsp;The greater the number the more additional info the scheme may output to
 * &nbsp;&nbsp;&nbsp;the console (0 = off).
 * &nbsp;&nbsp;&nbsp;default: 0
 * &nbsp;&nbsp;&nbsp;minimum: 0
 * </pre>
 *
 * <pre>-paintlet &lt;adams.gui.visualization.stats.paintlet.VsFitPaintlet&gt; (property: paintlet)
 * &nbsp;&nbsp;&nbsp;painlet for plotting the vs fit plot
 * &nbsp;&nbsp;&nbsp;default: adams.gui.visualization.stats.paintlet.VsFitPaintlet
 * </pre>
 *
 <!-- options-end -->
 *
 * @author msf8
 * @version $Revision: 3270 $
 */
public class VersusFitOptions
extends OptionHandlingObject{

  /** for serialization */
  private static final long serialVersionUID = -4737656972085433346L;

  /**Paintlet for plotting the versus fit*/
  protected VsFitPaintlet m_Val;

  public String globalInfo() {
    return "Class that contains options for the versusfit plot";
  }

  public void defineOptions() {
    super.defineOptions();
    //paintlet for plotting
    m_OptionManager.add(
	"paintlet", "paintlet", new VsFitPaintlet());
  }

  /**
   * Set the paintlet for plotting the versus fit
   * @param val			Paintlet for plotting
   */
  public void setPaintlet(VsFitPaintlet val) {
    m_Val = val;
  }

  /**
   * Get the paintlet used to plot the versus fit
   * @return			paintlet used
   */
  public VsFitPaintlet getPaintlet() {
    return m_Val;
  }

  /**
   * Tip text for the paintlet property
   * @return			String describing the property
   */
  public String paintletTipText() {
    return "painlet for plotting the vs fit plot";
  }
}