/*
 * ProbabilityPlotPanel.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.stats.probabilityplot;

import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.axis.Visibility;
import adams.gui.visualization.core.plot.Axis;

/**
 * Panel for displaying the probability plot data.
 *
 * @author msf8
 * @version $Revision: 3270 $
 */
public class ProbabilityPlotPanel
extends PlotPanel{

  /** for serialization */
  private static final long serialVersionUID = -1780061697297551334L;

  protected void initGUI() {
    super.initGUI();
    setAxisVisibility(Axis.LEFT, Visibility.VISIBLE);
    setAxisVisibility(Axis.BOTTOM, Visibility.VISIBLE);
    m_AxisLeft.setNumberFormat("#.##");
  }

  /**
   * Called by the probability plot once the fields have been set
   */
  public void reset() {
    m_AxisLeft.setTopMargin(0.05);
    m_AxisBottom.setTopMargin(0.05);
    validate();
    repaint();
  }
}