/*
 * VersusOrderPanel.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.stats.fourinone;

import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.axis.Visibility;
import adams.gui.visualization.core.plot.Axis;

/**
 * Panel for displaying the versus order data
 * @author msf8
 * @version $Revision: 3270 $
 *
 */
public class VersusOrderPanel
extends PlotPanel{

  /** for serialization */
  private static final long serialVersionUID = 3783360576257975446L;

  protected void initGUI() {
    super.initGUI();
    setAxisVisibility(Axis.LEFT, Visibility.VISIBLE);
    setAxisVisibility(Axis.BOTTOM, Visibility.VISIBLE);
    m_AxisLeft.setNumberFormat("#.##");
    m_AxisBottom.setNumberFormat("#");
    m_AxisLeft.setTopMargin(0.05);
    m_AxisLeft.setBottomMargin(0.05);
    m_AxisBottom.setTopMargin(0.05);
    m_AxisBottom.setBottomMargin(0.05);
    m_AxisLeft.setAxisName("Residuals");
    m_AxisBottom.setAxisName("Order");
    revalidate();
    repaint();
  }
}