/*
 * ArffUtils.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.data.weka;

import adams.data.report.AbstractField;

/**
 * A helper class for ARFF related stuff.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3507 $
 */
public class ArffUtils {

  /** the prefix for notes. */
  public final static String PREFIX_NOTE = "note-";

  /** the prefix for additional fields. */
  public final static String PREFIX_ADDITIONALFIELDS = "additional-";

  /**
   * Returns the name of the attribute containing the database ID.
   *
   * @return		the attribute name
   */
  public static String getDBIDName() {
    return "db_id";
  }

  /**
   * Returns the name of the attribute containing the ID of the data container.
   *
   * @return		the attribute name
   */
  public static String getIDName() {
    return "id";
  }

  /**
   * Returns the name of an attribute for a field.
   *
   * @param field	the field to generate the name for
   * @return		the attribute name
   */
  public static String getFieldName(AbstractField field) {
    return field.getName();
  }

  /**
   * Returns the name of an attribute for an additional field. Gets prefixed
   * with "additional-".
   *
   * @param field	the field to generate the name for
   * @return		the attribute name
   * @see		#PREFIX_ADDITIONALFIELDS
   */
  public static String getAdditionalFieldName(AbstractField field) {
    return PREFIX_ADDITIONALFIELDS + field.getName();
  }

  /**
   * Returns the name of an attribute for a note. Gets prefixed
   * with "note-".
   *
   * @param prefix	the note prefix to generate the name for
   * @return		the attribute name
   * @see		#PREFIX_NOTE
   */
  public static String getNoteName(String prefix) {
    return PREFIX_NOTE + prefix;
  }
}
