/**
 * WekaEditorsRegistration.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.goe;

/**
 * Registers first the WEKA GenericObjectEditor editors and the ADAMS ones.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2822 $
 */
public class WekaEditorsRegistration
  extends AbstractEditorRegistration {

  /** for serialization. */
  private static final long serialVersionUID = -2908979337117222215L;

  /** whether registration already occurred. */
  protected static boolean m_Registered;

  /**
   * Returns whether registration already occurred.
   *
   * @return		true if registration already occurred
   */
  protected boolean hasRegistered() {
    return m_Registered;
  }

  /**
   * Performs the registration of the editors.
   *
   * @return		true if registration successful
   */
  protected boolean doRegister() {
    weka.gui.GenericObjectEditor.registerEditors();
    Editors.registerEditors();
    m_Registered = true;
    return true;
  }
}
