/**
 * AdamsGenericObjectEditorHandler.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.goe;

import java.beans.PropertyEditor;

import javax.swing.JPanel;

import adams.core.ClassLocator;

/**
 * Handler for the WEKA GenericObjectEditor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4129 $
 */
public class WekaGenericObjectEditorHandler
  extends AbstractGenericObjectEditorHandler {

  /** for serialization. */
  private static final long serialVersionUID = 7963512759650622657L;

  /**
   * Sets the class type to use.
   *
   * @param editor	the editor to update
   * @param cls		the class to set
   * @return		true if successfully set
   */
  public boolean setClassType(Object editor, Class cls) {
    ((weka.gui.GenericObjectEditor) editor).setClassType(cls);
    return true;
  }

  /**
   * Returns the class type currently in use.
   *
   * @param editor	the editor to query
   * @return		always Object.class
   */
  public Class getClassType(Object editor) {
    return Object.class;
  }

  /**
   * Sets whether the class can be changed in the dialog.
   *
   * @param editor	the editor to update
   * @param canChange	if true the class can be changed in the dialog
   * @return		true if successfully set
   */
  public boolean setCanChangeClassInDialog(Object editor, boolean canChange) {
    ((weka.gui.GenericObjectEditor) editor).setCanChangeClassInDialog(canChange);
    return true;
  }

  /**
   * Returns whether the class can be changed in the dialog.
   *
   * @param editor	the editor to query
   * @return		true if the class can be changed in the dialog
   */
  public boolean getCanChangeClassInDialog(Object editor) {
    return ((weka.gui.GenericObjectEditor) editor).getCanChangeClassInDialog();
  }

  /**
   * Sets the editor value.
   *
   * @param editor	the editor to update
   * @param value	the object to set
   * @return		true if successfully set
   */
  public boolean setValue(Object editor, Object value) {
    ((weka.gui.GenericObjectEditor) editor).setValue(value);
    return true;
  }

  /**
   * Returns the value currently being edited.
   *
   * @param editor	the editor to query
   * @return		the current editor value
   */
  public Object getValue(Object editor) {
    return ((weka.gui.GenericObjectEditor) editor).getValue();
  }

  /**
   * Checks whether the given class can be processed.
   *
   * @param cls		the class to inspect
   * @return		always true
   */
  public boolean handles(Class cls) {
    return ClassLocator.isSubclass(weka.gui.GenericObjectEditor.class, cls);
  }

  /**
   * Checks whether the editor supplies its own panel.
   *
   * @param editor	the editor to check
   * @return		true if the editor provides a panel
   */
  public boolean hasCustomPanel(PropertyEditor editor) {
    return (editor instanceof weka.gui.CustomPanelSupplier);
  }

  /**
   * Returns the custom panel of the editor.
   *
   * @param editor	the editor to obtain the panel from
   * @return		the custom panel, null if none available
   */
  public JPanel getCustomPanel(PropertyEditor editor) {
    if (editor instanceof weka.gui.CustomPanelSupplier)
      return ((weka.gui.CustomPanelSupplier) editor).getCustomPanel();
    else
      return null;
  }
}
